% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.start.limits.R
\name{logistic.start.limits}
\alias{logistic.start.limits}
\title{logistic.start.limits - Start and limit values for logistic distance function}
\usage{
logistic.start.limits(dist, covars, expansions, w.lo, w.hi)
}
\arguments{
\item{dist}{A numeric vector containing observed distances with measurement
units.}

\item{covars}{Data frame containing values of covariates at 
each observation in \code{dist}.}

\item{expansions}{A scalar specifying the number of terms 
in \code{series}. Depending on the series, this could be 0 through 5.
The default of 0 equates to no expansion terms of any type.}

\item{w.lo}{Scalar value of the lowest observable distance, with measurement
units.  
This is the \emph{left truncation} sighting distance.  Values less than 
\code{w.lo} are allowed in \code{dist}, but are ignored and 
their likelihood value is set to
 \code{NA} in the output.}

\item{w.hi}{Scalar value of the largest observable distance, with measurement
units.  
This is the \emph{right truncation} sighting distance.
Values greater than \code{w.hi} are allowed in \code{dist}, 
but are ignored and their likelihood value is 
set to \code{NA} in the output.}
}
\value{
A list containing the following components:
\itemize{
   \item \code{start} : a vector of starting values
   \item \code{lowlimit} : a vector of lower limits (can be -Inf)
   \item \code{highlimit} : a vector of upper limits (can be Inf)
   \item \code{nms} : a vector containing names of the parameters
}
}
\description{
Starting values and limits for parameters of the logistic 
distance function.
}
\details{
This function is usually called within 
\code{F.start.limits}.
}
