% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_MVE.R
\name{do.mve}
\alias{do.mve}
\title{Minimum Volume Embedding}
\usage{
do.mve(
  X,
  ndim = 2,
  knn = ceiling(nrow(X)/10),
  kwidth = 1,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  tol = 1e-04,
  maxiter = 10
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{knn}{size of \eqn{k}-nn neighborhood.}

\item{kwidth}{bandwidth for Gaussian kernel.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{tol}{stopping criterion for incremental change.}

\item{maxiter}{maximum number of iterations allowed.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Minimum Volume Embedding (MVE) is a nonlinear dimension reduction
algorithm that exploits semidefinite programming (SDP), like MVU/SDE.
Whereas MVU aims at stretching through all direction by maximizing
\eqn{\sum \lambda_i}, MVE only opts for unrolling the top eigenspectrum
and chooses to shrink left-over spectral dimension. For ease of use,
unlike kernel PCA, we only made use of Gaussian kernel for MVE.
}
\examples{
\dontrun{
## use a small subset of iris data
set.seed(100)
id  = sample(1:150, 50)
X   = as.matrix(iris[id,1:4])
lab = as.factor(iris[id,5])

## try different connectivity levels
output1 <- do.mve(X, knn=5)
output2 <- do.mve(X, knn=10)
output3 <- do.mve(X, knn=20)

## Visualize two comparisons
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, main="knn:k=5",  pch=19, col=lab)
plot(output2$Y, main="knn:k=10", pch=19, col=lab)
plot(output3$Y, main="knn:k=20", pch=19, col=lab)
par(opar)
}

}
\references{
\insertRef{shaw_minimum_2007}{Rdimtools}
}
\seealso{
\code{\link{do.mvu}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
