% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_nonlinear_MMDS.R
\name{do.mmds}
\alias{do.mmds}
\title{Metric Multidimensional Scaling}
\usage{
do.mmds(X, ndim = 2, ...)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{...}{extra parameters including \describe{
\item{maxiter}{maximum number of iterations for metric MDS updates (default: 100).}
\item{abstol}{stopping criterion for metric MDS iterations (default: 1e-8).}
}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Metric MDS is a nonlinear method that is solved iteratively. We adopt a
well-known SMACOF algorithm for updates with uniform weights over all pairwise
distances after initializing the low-dimensional configuration via classical MDS.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare with other methods
pca2d <- do.pca(X, ndim=2)
cmd2d <- do.mds(X, ndim=2)
mmd2d <- do.mmds(X, ndim=2)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(pca2d$Y, col=lab, pch=19, main="PCA")
plot(cmd2d$Y, col=lab, pch=19, main="Classical MDS")
plot(mmd2d$Y, col=lab, pch=19, main="Metric MDS")
par(opar)
}

}
\references{
\insertRef{leeuw_applications_1977}{Rdimtools}

\insertRef{borg_modern_2010}{Rdimtools}
}
\concept{nonlinear_methods}
