% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v1_linear_OLPP.R
\name{do.olpp}
\alias{do.olpp}
\title{Orthogonal Locality Preserving Projection}
\usage{
do.olpp(
  X,
  ndim = 2,
  type = c("proportion", 0.1),
  symmetric = c("union", "intersect", "asymmetric"),
  weight = TRUE,
  t = 1
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{symmetric}{one of \code{"intersect"}, \code{"union"} or \code{"asymmetric"} is supported. Default is \code{"union"}.
See also \code{\link{aux.graphnbd}} for more details.}

\item{weight}{\code{TRUE} to perform LPP on weighted graph, or \code{FALSE} otherwise.}

\item{t}{bandwidth for heat kernel in \eqn{(0,\infty)}}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Orthogonal Locality Preserving Projection (OLPP) is a variant of \code{do.lpp}, which
extracts orthogonal basis functions to reconstruct the data in a more intuitive fashion.
It adopts PCA as preprocessing step and uses only one eigenvector at each iteration in that
it might incur warning messages for solving near-singular system of linear equations.
}
\examples{
\dontrun{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

##  connecting 10\% and 25\% of data for graph construction each.
output1 <- do.olpp(X,ndim=2,type=c("proportion",0.10))
output2 <- do.olpp(X,ndim=2,type=c("proportion",0.25))

## Visualize
#  In theory, it should show two separated groups of data
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(output1$Y, col=label, pch=19, main="OLPP::10\% connected")
plot(output2$Y, col=label, pch=19, main="OLPP::25\% connected")
par(opar)
}

}
\references{
\insertRef{cai_orthogonal_2006}{Rdimtools}
}
\seealso{
\code{\link{do.lpp}}
}
\author{
Kisung You
}
\concept{linear_methods}
