% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ver2_nonlinear_MMDS.R
\name{do.mmds}
\alias{do.mmds}
\title{Metric Multidimensional Scaling}
\usage{
do.mmds(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten"),
  maxiter = 100,
  abstol = 1e-06
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension (default: 2).}

\item{preprocess}{an option for preprocessing the data. Default is \code{"null"}.
See also \code{\link{aux.preprocess}} for more details.}

\item{maxiter}{maximum number of iterations for metric MDS updates (default: 100).}

\item{abstol}{stopping criterion for metric MDS iterations (default: 1e-6).}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Metric MDS is a nonlinear method that is solved iteratively. We adopt a
well-known SMACOF algorithm for updates with uniform weights over all pairwise
distances after initializing the low-dimensional configuration via classical MDS.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
lab   = as.factor(iris[,5])

## compare with other methods
pca2d <- do.pca(X, ndim=2)
cmd2d <- do.mds(X, ndim=2)
mmd2d <- do.mmds(X, ndim=2)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(pca2d$Y, col=lab, pch=19, main="PCA")
plot(cmd2d$Y, col=lab, pch=19, main="Classical MDS")
plot(mmd2d$Y, col=lab, pch=19, main="Metric MDS")
par(opar)
}

}
\references{
\insertRef{leeuw_applications_1977}{Rdimtools}

\insertRef{borg_modern_2010}{Rdimtools}
}
\concept{nonlinear_methods}
