% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ver2_linear_MDS.R
\name{do.mds}
\alias{do.mds}
\title{(Classical) Multidimensional Scaling}
\usage{
do.mds(
  X,
  ndim = 2,
  preprocess = c("center", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an option for preprocessing the data. Default is \code{"center"}.
See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
\code{do.mds} performs a classical Multidimensional Scaling (MDS) using
\code{Rcpp} and \code{RcppArmadillo} package to achieve faster performance than
\code{\link[stats]{cmdscale}}.
}
\examples{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
lab   = as.factor(iris[subid,5])

## try different preprocessing
out1 <- do.mds(X,ndim=2)
out2 <- do.mds(X,ndim=2,preprocess="cscale")
out3 <- do.mds(X,ndim=2,preprocess="whiten")

## extract embeddings for each procedure
Y1 <- out1$Y; Y2 <- out2$Y; Y3 <- out3$Y

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(Y1, pch=19, col=lab, main="MDS::center")
plot(Y2, pch=19, col=lab, main="MDS::decorrelate")
plot(Y3, pch=19, col=lab, main="MDS::whiten")
par(opar)

}
\references{
\insertRef{kruskal_multidimensional_1964}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
