% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ELPP2.R
\name{do.elpp2}
\alias{do.elpp2}
\title{Enhanced Locality Preserving Projection (2013)}
\usage{
do.elpp2(
  X,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Enhanced Locality Preserving Projection proposed in 2013 (ELPP2) is built upon
a parameter-free philosophy from PFLPP. It further aims to exclude its projection
to be uncorrelated in the sense that the scatter matrix is placed in a generalized eigenvalue problem.
}
\examples{
\donttest{
## use iris data
data(iris)
X   = as.matrix(iris[,1:4])
lab = as.factor(iris[,5])

## compare with PCA and PFLPP
out1 = do.pca(X, ndim=2)
out2 = do.pflpp(X, ndim=2)
out3 = do.elpp2(X, ndim=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(3,1))
plot(out1$Y, col=lab, main="PCA")
plot(out2$Y, col=lab, main="Parameter-Free LPP")
plot(out3$Y, col=lab, main="Enhanced LPP (2013)")
par(opar)
}

}
\references{
\insertRef{dornaika_enhanced_2013}{Rdimtools}
}
\seealso{
\code{\link{do.pflpp}}
}
\author{
Kisung You
}
\concept{linear_methods}
