% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_IDMAP.R
\name{do.idmap}
\alias{do.idmap}
\title{Interactive Document Map}
\usage{
do.idmap(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  engine = c("NNP", "FastMap")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{engine}{either \code{NNP} or \code{FastMap}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Interactive Document Map originates from text analysis to generate maps of documents by placing
similar documents in the same neighborhood. After defining pairwise distance with cosine similarity,
authors asserted to use either \code{NNP} or \code{FastMap} as an engine behind.
}
\examples{
\donttest{
## load iris data
data(iris)
X     <- as.matrix(iris[,1:4])
label <- as.integer(iris$Species)

## let's compare with other methods
out1 <- do.pca(X, ndim=2)
out2 <- do.sne(X, ndim=2)
out3 <- do.idmap(X, ndim=2, engine="NNP")

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, col=label, main="PCA")
plot(out2$Y, col=label, main="SNE")
plot(out3$Y, col=label, main="IDMAP")
par(opar)
}

}
\references{
\insertRef{minghim_contentbased_2006}{Rdimtools}
}
\seealso{
\code{\link{do.nnp}}, \code{\link{do.fastmap}}
}
