% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{compose}
\alias{compose}
\title{Select more specific SNOMED CT concepts based on attributes}
\usage{
compose(
  conceptId,
  CDB,
  composeLookup,
  attributes_conceptIds = bit64::integer64(0),
  due_to_conceptIds = bit64::integer64(0),
  without_conceptIds = bit64::integer64(0),
  with_conceptIds = bit64::integer64(0),
  SNOMED = getSNOMED(),
  show_all_matches = FALSE
)
}
\arguments{
\item{conceptId}{SNOMED CT concept to refine}

\item{CDB}{SNOMED CT concept database, as created by createCDB.
An environment containing the following data tables: FINDINGS,
QUAL, CAUSES, BODY, FINDINGS, OTHERSUB, OVERLAP, TRANSITIVE}

\item{composeLookup}{lookup table created by createComposeLookup}

\item{attributes_conceptIds}{SNOMED concept Ids of attributes of concept
e.g. laterality, severity, acuteness}

\item{due_to_conceptIds}{SNOMED concept Ids of cause}

\item{without_conceptIds}{SNOMED concept Ids of conditions stated to be
absent}

\item{with_conceptIds}{SNOMED concept Ids of conditions also present}

\item{SNOMED}{environment containing SNOMED CT tables}

\item{show_all_matches}{whether to stop if an exact match is found,
or continue to search for all potential matches}
}
\value{
a refined SNOMED concept Id
}
\description{
Finds the most specific SNOMED CT concepts that matches the
combination of a root concept and attributes. Based on a
composeLookup table
}
\examples{
SNOMED <- sampleSNOMED()
miniCDB <- createCDB(SNOMED)

D <- decompose('Cor pulmonale', CDB = miniCDB)
print(D)

# --------------------------------------------------------
# 83291003 | Cor pulmonale (disorder)
# --------------------------------------------------------
# Root : 128404006 | Right heart failure (disorder)
# - Due to : 19829001 | Disorder of lung (disorder)
#
# --------------------------------------------------------
# 83291003 | Cor pulmonale (disorder)
# --------------------------------------------------------
# Root : 367363000 | Right ventricular failure (disorder)
# - Due to : 19829001 | Disorder of lung (disorder)

# Compile decompositions into a lookup table
CL <- createComposeLookup(D, CDB = miniCDB)

compose(as.SNOMEDconcept('Right heart failure'),
  due_to_conceptIds = as.SNOMEDconcept('Disorder of lung'),
  CDB = miniCDB, composeLookup = CL)
# [1] "83291003 | Cor pulmonale (disorder)"
}
\seealso{
decompose, batchDecompose, createComposeLookup
}
