% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundoc.R
\name{bind_cols}
\alias{bind_cols}
\title{Bind multiple data frames by column}
\usage{
bind_cols(
  ...,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{...}{Data frames to combine. Each argument can either be a data frame,
a list that could be a data frame, or a list of data frames.
Inputs are \link[vctrs:theory-faq-recycling]{recycled} to the same length,
then matched by position.}

\item{.name_repair}{One of \code{"unique"}, \code{"universal"}, or
\code{"check_unique"}. See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for the meaning of these
options.}
}
\value{
A data frame the same type as the first element of \code{...}.
}
\description{
Bind any number of data frames by column, making a wider result.
This is similar to \code{do.call(cbind, dfs)}.

Where possible prefer using a \link[=left_join]{join} to combine multiple
data frames. \code{bind_cols()} binds the rows in order in which they appear
so it is easy to create meaningless results without realising it.
}
\examples{
df1 <- tibble(x = 1:3)
df2 <- tibble(y = 3:1)
bind_cols(df1, df2)

# Row sizes must be compatible when column-binding
try(bind_cols(tibble(x = 1:3), tibble(y = 1:2)))
}
