% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplfit_onerun.R
\name{run_fit}
\alias{run_fit}
\title{Run parametric fits using types of models on concentration-response datasets}
\usage{
run_fit(d, modls, keep_sets = c("fit_set", "resp_set"), n_samples = NULL, ...)
}
\arguments{
\item{d}{Datasets with concentration-response data.
An example is \link{zfishbeh}.
mask column is optional.}

\item{modls}{The model types for the fitting.
Currently available models are 3-parameter Hill model (hill), constant model (cnst),
and Curve Class2 4-parameter Hill model (cc2).
Multiple values are only allowed for the hill and cnst combination.}

\item{keep_sets}{Output datasets. Multiple values are allowed.
Default values are fit_set and resp_set.
fit_set is a must.
\itemize{
\item fit_set: a tibble with output from model fits
\item resp_set: a tibble with fitted response data from the winning model.
If winning model is hill + no fit or cc2 + hit=4(inactive), response is NA.
If winning model is cnst, median of all responses is reported for each concentration.
}}

\item{n_samples}{NULL (default) for no bootstrap samples are generated or number of samples to be generated from bootstrapping.
When n_samples is not NULL, modls currently needs to be hill.}

\item{...}{The named input configurations for replacing the default configurations.
The input configuration needs to add model type as the prefix.
For example, hill_pdir = -1 will set the Hill fit only to the decreasing direction.
Add cc2_classSD = 10 will set the classification SD to 10\%.
Often 5\% or 10\% are used.}
}
\value{
A list of named components: result and result_nested.
The result component is also a list of output sets depending on the parameter, \emph{keep_sets}.
The result_nested component is a tibble with input data nested in a column, input,
and output data nested in a column, output.
}
\description{
Confidence intervals of activity metrics can be obtained through bootstrap approach.
The bootstrap samples are generated by adding the residuals (the difference between the original responses and the Hill fit) to
the fitted response (only for Hill equation, 3-parameter).
}
\section{Data structure}{
output
|- result (list)
|   |- fit_set
|   |- resp_set
|
|- result_nested (tibble)

The prefix of the column names in the \emph{fit_set} are the used models.
The \emph{win_modl} is the winning model.
}

\examples{

# It is suggested to use na.omit on the dataset to see if any data will be removed
\donttest{
# use hill + cnst model
fitd <- run_fit(zfishbeh, modls = c("hill", "cnst"))

# use only hill model and fit only to the decreasing direction, keep only the fit_set output
fitd <- run_fit(zfishbeh, modls = "hill", keep_sets = "fit_set", hill_pdir = -1)

# use cc2 model + higher classification SD
fitd <- run_fit(zfishbeh, modls = "cc2", cc2_classSD = 10)

# fit to the bootstrap samples using hill
fitd <- run_fit(zfishbeh, n_samples = 2, modls = "hill")
}


}
\seealso{
\code{\link[=fit_modls]{fit_modls()}} for model fit information and the following analyses using \code{\link[=summarize_fit_output]{summarize_fit_output()}}.
for dichotomous response (see \link{zfishdev}), use \code{create_dataset()} first.
}
