% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssWrappers.R
\name{stripchart}
\alias{stripchart}
\title{Draw styled strip chart}
\usage{
stripchart(x, Rcss = "default", Rcssclass = NULL, ...)
}
\arguments{
\item{x}{list of numeric vectors}

\item{Rcss}{style sheet object. Leave "default" to use a style
defined via RcssSetDefaultStyle()}

\item{Rcssclass}{character, style class}

\item{...}{Further parameters, see documentation of graphics::stripchart}
}
\description{
This is a wrapper for R's stripchart function.
See R's documentation for graphics::stripchart for further details.
}
\examples{

# draw a complete strip-chart plot
dataset <- list(A=c(1,9,3,8), B=c(3,4,2,9,2), C=rpois(8, 10))
stripchart(dataset)
stripchart(dataset, method="jitter", vertical=TRUE, pch=19)

}
