# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Deserialize JSON into R Objects
#'
#' @param json \code{character()} containing one or more strings of JSON data.
#'
#' @param json_pointer \code{character(1L)}, default: \code{""}
#'
#' @param empty_array default: \code{NULL}. Any R object to return for empty JSON arrays.
#'
#' @param empty_object default: \code{NULL}. Any R object to return for empty JSON objects.
#'
#' @param simplify_to \code{integer(1L)}, default: \code{0L}.
#'     Maximum simplification level.
#'     0: data frame, 1: matrix, 2: vector, 3: list (no simplification)
#'
#' @param type_policy \code{integer(1L)}, default: \code{0L}.
#'     Level of type strictness.
#'     0: merge everything, 1: merge numbers, 2: strict (mixed types are not merged)
#'
#' @param int64_r_type \code{integer(1L)} default: \code{0L}
#'     How to return big integers to R.
#'     0: \code{double}, 1: string, 2: \code{bit64::integer64}-compatible number
#'
#' @details
#' Instead of using \code{lapply()} for vectors containing multiple strings/file paths,
#'     just use \code{.deserialize_json()} and \code{.load_json()} directly as they are vectorized
#'     (in the R sense). This is much more efficient as the underlying \code{simdjson::parser} can
#'     reuse internal buffers between parses. Since the overwhelming majority of JSON objects
#'     parsed will not result in R scalars, a \code{list()} is always returned when multiple items
#'     are passed to \code{.deserialize_json()} or \code{.load_json()}. Also in keeping with
#'     \code{lapply()}'s behavior, if the data passed has \code{names()}, the returned object will
#'     have the same names.
#'
#' @keywords internal
#'
#' @examples
#' # .deserialize_json() ======================================================
#' RcppSimdJson:::.deserialize_json('[[1,2,3],[4,5,6]]')
#'
#' RcppSimdJson:::.deserialize_json(
#'   '[{"a":1,"b":true},{"a":2,"b":false,"c":null}]'
#' )
#'
#' RcppSimdJson:::.deserialize_json(
#'   c(
#'     json1 = "[[1,2,3],[4,5,6]]",
#'     json2 = '[{"a":1,"b":true},{"a":2,"b":false,"c":null}]'
#'   )
#' )
#'
.deserialize_json <- function(json, json_pointer = "", empty_array = NULL, empty_object = NULL, simplify_to = 0L, type_policy = 0L, int64_r_type = 0L) {
    .Call(`_RcppSimdJson_deserialize_json`, json, json_pointer, empty_array, empty_object, simplify_to, type_policy, int64_r_type)
}

#' @rdname dot-deserialize_json
#'
#' @param file_path \code{character()} containing one or more paths to files containing
#'    JSON data.
#'
#' @examples
#' # .load_json() =============================================================
#' single_file <- system.file("jsonexamples", "small", "flatadversarial.json",
#'                            package = "RcppSimdJson")
#' RcppSimdJson:::.load_json(single_file)
#'
#' multiple_files <- vapply(
#'   c("flatadversarial.json", "adversarial.json"),
#'   function(.x) {
#'     system.file("jsonexamples/small", .x, package = "RcppSimdJson")
#'   },
#'   character(1L)
#' )
#' RcppSimdJson:::.load_json(multiple_files)
#'
.load_json <- function(file_path, json_pointer = "", empty_array = NULL, empty_object = NULL, simplify_to = 0L, type_policy = 0L, int64_r_type = 0L) {
    .Call(`_RcppSimdJson_load_json`, file_path, json_pointer, empty_array, empty_object, simplify_to, type_policy, int64_r_type)
}

.exceptions_enabled <- function() {
    .Call(`_RcppSimdJson_exceptions_enabled`)
}

.check_int64 <- function() {
    .Call(`_RcppSimdJson_check_int64`)
}

.validateJSON <- function(filename) {
    .Call(`_RcppSimdJson_validateJSON`, filename)
}

#' Simple JSON Parsing Example
#'
#' This example is adapted from a blogpost announcing an earlier \sQuote{simdjson}
#' release. It is of interest mostly for the elegance and conciseness of its C++
#' code rather than for any functionality exported to R.
#'
#' The function takes no argument and returns nothing.
#'
#' @examples
#' parseExample()
parseExample <- function() {
    invisible(.Call(`_RcppSimdJson_parseExample`))
}

.cppVersion <- function() {
    .Call(`_RcppSimdJson_cppVersion`)
}

.unsupportedArchitecture <- function() {
    .Call(`_RcppSimdJson_unsupportedArchitecture`)
}

