% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{s_attr_regions}
\alias{s_attr_regions}
\title{Get regions defined by a structural attribute}
\usage{
s_attr_regions(
  corpus,
  s_attr,
  registry = Sys.getenv("CORPUS_REGISTRY"),
  data_dir = corpus_data_dir(corpus = corpus, registry = registry)
)
}
\arguments{
\item{corpus}{A length-one \code{character} vector with a corpus ID.}

\item{s_attr}{A length-one \code{character} vector stating a structural attribute.}

\item{registry}{A length-one \code{character} vector stating the registry
directory (defaults to CORPUS_REGISTRY environment variable).}

\item{data_dir}{The data directory of the corpus.}
}
\value{
A two-colum \code{matrix} with the regions defined by the structural
attribute: Column 1 defines left corpus positions and column 2 right corpus
positions of regions.
}
\description{
Get all regions defined by a structural attribute. Unlike
\code{get_region_matrix()} that returns a region matrix for a defined subset of
strucs, all regions are returned. As it is the fastest option, the function
reads the binary *.rng file for the structural attribute directly. The corpus
library (CL) is not used in this case.
}
\examples{
s_attr_regions("REUTERS", s_attr = "id")
}
