% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpm_mean.R
\name{mpm_mean}
\alias{mpm_mean}
\alias{mat_mean}
\title{Calculate a mean over a list of matrices or CompadreMat objects}
\usage{
mat_mean(x, na.rm = FALSE)

mpm_mean(x, na.rm = FALSE)
}
\arguments{
\item{x}{List of matrices (\code{mat_mean}) or list of CompadreMat objects
(\code{mpm_mean}), all of same dimension}

\item{na.rm}{Logical indicating whether missing values should be excluded
(see \emph{Details}). Defaults to \code{FALSE}.}
}
\value{
A matrix (\code{mat_mean}) or a CompadreMat object (\code{mpm_mean}).
}
\description{
Calculates an element-wise mean over a list of matrices or CompadreMat
objects of constant dimension.
}
\details{
If \code{na.rm == TRUE}, missing values are ignored in the calculation of the
mean matrix. If \code{na.rm == TRUE} and a given element is \code{NA} in
\emph{every} matrix within \code{x}, the value returned for that element will
be \code{0}.
}
\examples{
# there are four rows for species 'Haplopappus_radiatus' in Compadre
mpms <- Compadre$mat[Compadre$SpeciesAuthor == "Haplopappus_radiatus"]
mpm_mean(mpms)

# extract list of matA and take mean
mats <- matA(mpms)
mat_mean(mats)
}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{string_representation}}
}
\author{
Patrick Barks <patrick.barks@gmail.com>

Owen R. Jones <jones@biology.sdu.dk>
}
\concept{data management}
