% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeSSSC.R
\name{KwaySSSC}
\alias{KwaySSSC}
\title{Semi-supervised spectral clustering}
\usage{
KwaySSSC(sim, K = 0, list.ML = list(), list.CNL = list(),
  alphas = seq(from = 0, to = 1, length = 100), K.max = 20)
}
\arguments{
\item{sim}{similarity matrix.}

\item{K}{number of clusters (0 for automatic estimation).}

\item{list.ML}{list of ML (must-link) constrained pairs.}

\item{list.CNL}{list of CNL (cannot-link) constrained pairs.}

\item{alphas}{numeric vector for the weight of constraints considered.}

\item{K.max}{maximal number of clusters.}
}
\value{
The function returns a list containing:
\item{alpha}{chosen alpha.}
\item{label}{vector of labels.}
\item{medoids}{matrix of cluster centers in the space of the K first normalized eigenvectors.}
\item{id.med}{vector containing the medoids indices.}
\item{x}{matrix containing, in columns, the eigenvectors of the similarity matrix.}
\item{eigen.val}{vector containing the eigenvalues of the similarity matrix.}
\item{cluster.info}{some statistics on each cluster.}
\item{K}{number of clusters.}
}
\description{
Perform semi-supervised spectral clustering thanks to a similarity matrix and constraints sets (according to Wacquet et al., 2013).
}
\details{
KwaySSSC returns a partition obtained by semi-supervised spectral clustering (according to Wacquet et al., 2013)
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
ML <- list()
ML[[1]] <- c(sel="10",mem="20")
ML[[2]] <- c(sel="60",mem="70")

CNL <- list()
CNL[[1]] <- c(sel="30",mem="80")
CNL[[2]] <- c(sel="90",mem="120")

sim <- computeGaussianSimilarity(dat, 1)
res <- KwaySSSC(sim, K=0, list.ML=ML, list.CNL=CNL)

plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
col = res$label, main = "Constrained spectral clustering")

}
\references{
G. Wacquet, E. Poisson Caillault, D. Hamad, P.-A. Hebert, Constrained spectral embedding for K-way data clustering, Pattern Recognition Letters, 2013, 34 (9), pp.1009-1017.
}
\seealso{
\code{\link{computeSemiSupervised}}, \code{\link{computeCKmeans}}
}
\keyword{internal}
