context("Provenance capture")
library(Rclean)
library(jsonlite)
library(igraph)
library(formatR)
library(utils)

## Loading test data
test.dat.loc <- system.file("exec", "micro_R.json", package="Rclean")
options(prov.json = readLines(test.dat.loc))
prov <- read.prov(options()$prov.json)
expect_match(mode(prov), "list")
expect_equal(length(prov), 2)

context("Provenance graph")
expect_match(mode(prov$graph), "numeric")
expect_match(class(prov$graph), "matrix")

context("Provenance info")
expect_equal(length(prov$info), 3)

context("Code cleaning: initiate")
micro.test <- clean()
expect_equal(length(micro.test), 2)
expect_match(mode(micro.test), "list")
expect_match(names(micro.test)[1], "Files")
expect_match(names(micro.test)[2], "Objects")
expect_match(micro.test$Files[1], "test.test")
expect_match(micro.test$Files[2], "test.pdf")
expect_match(micro.test$Objects[1], "x")
expect_match(micro.test$Objects[2], "y")

context("Code cleaning: get result")
micro.result.x.test <- clean(result = "x")
expect_match(micro.result.x.test[1] , "x <- 1")
expect_match(micro.result.x.test[2] , "y <- 3")
expect_match(micro.result.x.test[3] , "x <- x \\+ y")
micro.result.y.test <- clean(result = "y")
expect_match(micro.result.y.test[1] , "y <- 3")
micro.result.test_test.test <- clean(result = "test.test")
expect_match(micro.result.test_test.test[1], "x <- 1")
expect_match(micro.result.test_test.test[2], "y <- 3")
expect_match(micro.result.test_test.test[3], "x <- x \\+ y")
expect_match(micro.result.test_test.test[4], "write\\.csv\\(x, \"~/test\\.test\"\\)")

micro.result.test_pdf.test <- clean(result = "test.pdf")
expect_match(micro.result.test_pdf.test[1], "x <- 1")
expect_match(micro.result.test_pdf.test[2], "y <- 3")
expect_match(micro.result.test_pdf.test[3], "x <- x \\+ y")
expect_match(micro.result.test_pdf.test[4], "pdf\\(\"~/test.pdf\"\\)" )
expect_match(micro.result.test_pdf.test[5], "plot\\(x\\)")
expect_match(micro.result.test_pdf.test[6], "dev.off()")
