\name{Rcgminu}
\alias{Rcgminu}
\encoding{UTF-8}
\title{An R implementation of a bounded nonlinear conjugate gradient algorithm 
   with the Dai / Yuan update and restart. Based on Nash (1979) Algorithm 22 
   for its main structure.  CALL THIS VIA \code{Rcgmin} AND DO NOT USE DIRECTLY.}
\description{
  The purpose of \code{Rcgminu} is to minimize a bounds (box) and mask 
  constrained function 
  of many parameters by a nonlinear conjugate gradients method. This code is
  entirely in R to allow users to explore and understand the method. It 
  allows bounds (or box) constraints and masks (equality constraints) to be
  imposed on parameters. 

  This code should be called through \code{Rcgmin} which selects \code{Rcgminb}
  or \code{Rcgminu} according to the presence of bounds and masks.
}
\usage{
   Rcgminu(par, fn, gr, control = list(), \dots)
}
\arguments{
 \item{par}{A numeric vector of starting estimates.}
 \item{fn}{A function that returns the value of the objective at the
   supplied set of parameters \code{par} using auxiliary data in \dots.
   The first argument of \code{fn} must be \code{par}. }
 \item{gr}{A function that returns the gradient of the objective at the
   supplied set of parameters \code{par} using auxiliary data in \dots.
   The first argument of \code{fn} must be \code{par}. This function 
   returns the gradient as a numeric vector.

   The use of numerical gradients for Rcgminu is STRONGLY discouraged.}
 \item{control}{
    An optional list of control settings.  
 }
 \item{\dots}{Further arguments to be passed to \code{fn}.}
}
\details{
   Functions \code{fn} must return a numeric value.

   The \code{control} argument is a list.
   \describe{
   \item{maxit}{A limit on the number of iterations (default 500). Note that this is 
      used to compute a quantity \code{maxfeval}<-round(sqrt(n+1)*maxit) where n is the
      number of parameters to be minimized.}
   \item{trace}{Set 0 (default) for no output, >0 for trace output
      (larger values imply more output).}
   \item{eps}{Tolerance used to calculate numerical gradients. Default is 1.0E-7. See 
      source code for \code{Rcgminu} for details of application.}
   \item{\code{dowarn}}{= TRUE if we want warnings generated by optimx. Default is 
     TRUE.}
   \item{}{The source code \code{Rcgminu} for R is likely to remain a work in progress for some time, 
    so users should watch the console output.}
  }

  As of 2011-11-21 the following controls have been REMOVED

  \describe{
   \item{usenumDeriv}{There is now a choice of numerical gradient routines. See argument 
       \code{gr}.}
   \item{maximize}{To maximize user_function, supply a function that computes (-1)*user_function.
       An alternative is to call Rcgmin via the package optimx.}
  }
}
\value{
  A list with components:
  \item{par}{The best set of parameters found.}
  \item{value}{The value of the objective at the best set of parameters found.}
  \item{counts}{A two-element integer vector giving the number of calls to
          'fn' and 'gr' respectively. This excludes those calls needed
          to compute the Hessian, if requested, and any calls to 'fn'
          to compute a finite-difference approximation to the gradient.}
  \item{convergence}{An integer code. 
	 '0' indicates successful convergence.
         '1' indicates that the function evaluation count 'maxfeval' was reached.
         '2' indicates initial point is infeasible.}
  \item{message}{A character string giving any additional information returned
          by the optimizer, or 'NULL'.}
  \item{bdmsk}{Returned index describing the status of bounds and masks at the
        proposed solution. Parameters for which bdmsk are 1 are unconstrained
        or "free", those with bdmsk 0 are masked i.e., fixed. For historical
        reasons, we indicate a parameter is at a lower bound using -3 
         or upper bound using -1.}
}
\references{
   See \code{Rcgmin} documentation.
}
\seealso{\code{\link{optim}}}
\keyword{nonlinear}
\keyword{optimize}

