% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTicks.R
\name{getTicks}
\alias{getTicks}
\title{Get Ticks from Bloomberg}
\usage{
getTicks(security, eventType = "TRADE", startTime = Sys.time() - 60 * 60,
  endTime = Sys.time(), verbose = FALSE, returnAs = getOption("blpType",
  "matrix"), tz = Sys.getenv("TZ", unset = "UTC"),
  con = defaultConnection())
}
\arguments{
\item{security}{A character variable describing a valid security ticker}

\item{eventType}{A character variable describing an event, default
is \sQuote{TRADE}.}

\item{startTime}{A Datetime object with the start time, defaults
to one hour before current time}

\item{endTime}{A Datetime object with the end time, defaults
to current time}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{returnAs}{A character variable describing the type of return
object; currently supported are \sQuote{matrix} (also the default),
\sQuote{fts}, \sQuote{xts} and \sQuote{zoo}}

\item{tz}{A character variable with the desired local timezone,
defaulting to the value \sQuote{TZ} environment variable, and
\sQuote{UTC} if unset}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A numeric matrix with elements \sQuote{time}, (as a
\sQuote{POSIXct} object), \sQuote{values} and \sQuote{sizes}, or
an object of the type selected in \code{returnAs}.
}
\description{
This function uses the Bloomberg API to retrieve ticks for the requested security.
}
\examples{
\dontrun{
  getTicks("ES1 Index")
}
}
\author{
Dirk Eddelbuettel
}

