% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_res_extract.R
\name{rvn_res_extract}
\alias{rvn_res_extract}
\title{Extract function for Raven Reservoir object}
\usage{
rvn_res_extract(subs = NA, res = NA, prd = NULL)
}
\arguments{
\item{subs}{column name for plotting/extracting}

\item{res}{full reservoir data frame (including units) produced by res.read}

\item{prd}{time period for plotting, as string. See details}
}
\value{
\item{sim}{model simulation for specified column and period}
\item{obs}{observed data for specified column and period}
\item{inflow}{inflow simulation for specified column and period}
}
\description{
rvn_res_extract is used for extracting data from the Raven reservoir object.
Works for objects from \code{\link{rvn_res_read}} function (for reading in the ReservoirStages.csv
file).
}
\details{
rvn_res_extract is used to extract the modelled and observed data from a Raven
reservoir object by name reference. It is also easy to create plots of
modelled and observed data using this function. The simulated and observed
files are outputted regardless of whether a plot is created, for the
specified period.

The subs input is the name of the column desired for use; the most common
use of this will be for subbasins, where the names will be of the form
"subXX", for example "sub24".

The res object is the full reservoir object (res and units in one data
frame) created by the res.read function. Both the res and units are
required, since the units are placed onto the plots if one is created. This
is useful to at least see the units of the plotted variable, even if the
plot is later modified.

The prd input is used to specify a period for the plot and/or the data
output. The period should be specified as a string start and end date, of
the format "YYYY-MM-DD/YYYY-MM-DD", for example, "2006-10-01/2010-10-01". If
no period is supplied, the entire time series will be used.
}
\examples{

ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")

# Read in Raven Reservoirs file, store into myres
myres <- rvn_res_read(ff)

# Extract stage using this function
stage36 <- rvn_res_extract(subs="sub36",res=myres,prd="2002-10-01/2003-10-01")
summary(stage36)
summary(stage36$sim)

# Example for precipitation
precip <- rvn_res_extract(subs="precip",res=myres)

}
\seealso{
\code{\link{rvn_res_read}} for reading in the Reservoirs.csv file and
creating the object required in this function. \code{\link{rvn_res_plot}} for
plotting the extracted stage time series
}
