% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_annual_peak_event_error.R
\name{rvn_annual_peak_event_error}
\alias{rvn_annual_peak_event_error}
\title{Annual Peak Event Errors}
\usage{
rvn_annual_peak_event_error(
  sim,
  obs,
  mm = 9,
  dd = 30,
  add_line = TRUE,
  add_labels = TRUE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{mm}{month of water year (default 9)}

\item{dd}{day of water year (default 30)}

\item{add_line}{optionally adds a 1:1 line to the plot for reference
(default TRUE)}

\item{add_labels}{optionally adds labels for overpredict/underpredict on
right side axis (default TRUE)}
}
\value{
returns a list with peak event error data in a data frame, and a ggplot object
 \item{df_peak_event_error}{data frame of the calculated peak event errors}
 \item{p1}{ggplot object with plotted annual peak event errors}
}
\description{
rvn_annual_peak_event_error creates a plot of the annual observed and simulated
peak event errors.
}
\details{
This function creates a plot of the percent errors in simulated peak events
for each water year. The peaks are calculated as using flows from the same
day as the peak event in the observed series, i.e. the timing of the peak is
considered here. Note that the rvn_annual_peak_event function is first used to
obtain the peaks in each year, then the percent errors are calculated.

The percent errors are calculated as (QP_sim-QP_obs)/QP_obs*100, where QP is
the peak flow event.

The sim and obs should be of time series (xts) format and are assumed to be
of the same length and time period. The flow series are assumed to be daily
flows with units of m3/s.

The add_labels will add the labels of 'overprediction' and 'underprediction'
to the right hand side axis if set to TRUE. This is useful in interpreting
the plots.

Note that a plot title is purposely omitted in order to allow the automatic
generation of plot titles.
}
\examples{
# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# create a plot of peak annual errors with default options
peak1 <- rvn_annual_peak_event_error(sim, obs)
peak1$df_peak_event_error
peak1$p1

}
\seealso{
\code{\link{rvn_annual_peak}} to consider just the magnitude of each
year's peak \code{\link{rvn_annual_peak_error}} to calculate errors in peaks
}
