% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_subbasin_network_plot.R
\name{rvn_subbasin_network_plot}
\alias{rvn_subbasin_network_plot}
\title{Plot Raven subbasin network.}
\usage{
rvn_subbasin_network_plot(SBtable, labeled = FALSE)
}
\arguments{
\item{SBtable}{a valid table of Raven subbasins, obtained from \code{\link{rvn_rvh_read}}}

\item{labeled}{TRUE if the nodes are labeled with the SubBasin ID, SBID}
}
\value{
{p1}{ggplot object of subbasin network plot}
}
\description{
Generates a plot of the subbasin network from rvh file information.
}
\details{
Takes the information gathered from an .rvh file via the function \code{\link{rvn_rvh_read}} and
generates a plot object of the subbasin network,
where nodes are located at SubBasin lat-long centroids, and
edge widths of the network correspond to contributing upstream area.
}
\examples{
# read in rvh file
rvh <- rvn_rvh_read(system.file("extdata","Nith.rvh", package="RavenR"))

# create network plot of watershed structure from rvh file
rvn_subbasin_network_plot(rvh$SBtable)

# include labels
rvn_subbasin_network_plot(rvh$SBtable, labeled=TRUE)

}
\author{
James R. Craig, University of Waterloo
}
