% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_res_dygraph.R
\name{rvn_res_dygraph}
\alias{rvn_res_dygraph}
\title{Plot Raven reservoir/lake stage time series using dygraph}
\usage{
rvn_res_dygraph(resdata, timezone = "UTC", basins = "", figheight = 400)
}
\arguments{
\item{resdata}{reservoir stage time series data structure generated by \code{\link{rvn_res_read}} routine}

\item{timezone}{data timezone; defaults to UTC}

\item{basins}{list of subbasin names from reservoir file. Each subbasin creates separate dygraph plots}

\item{figheight}{height of figure, in pixels}
}
\value{
a list of plot handles to dygraph plots
}
\description{
rvn_res_dygraph plots modeled vs observed stage plots when supplied with reservoir stage data
structure read using \code{\link{rvn_res_read}}
}
\examples{
# read in Raven Reservoir Stages file
ff <- system.file("extdata","ReservoirStages.csv", package="RavenR")
resdata <- rvn_res_read(ff)

# view contents for all subbasins as dyGraph
dyplots <- rvn_res_dygraph(resdata)
dyplots[[1]]
dyplots[[2]]


}
\seealso{
\code{\link{rvn_hyd_dygraph}} to generate dygraphs for hydrograph series
}
