% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_base.R
\name{test_base}
\alias{test_base}
\title{The test statistic for the RE test with survey weights}
\usage{
test_base(Y_tilde, X, D, data_test, epsilon, B, N3, c, kappa, p, N,
  weights)
}
\arguments{
\item{Y_tilde}{the vector stacking the realisations y then the anticipated values psi of respective sizes n_y and n_p.}

\item{X}{the matrix of covariates. Set to a vector of 1 by default (in which case the test without covariates is performed).}

\item{D}{the vector stacking the dummies for the dataset of realisation : n_y ones then n_p zeros}

\item{data_test}{the matrix of sample moments}

\item{epsilon}{the parameter epsilonon inSection 3}

\item{B}{the number of bootstrap samples}

\item{N3}{a parameter equal to 1 if no covariates, to N otherwise}

\item{c}{the parameter c in  Section 3}

\item{kappa}{the parameter kappapa in  Section 3}

\item{p}{the parameter p in  Section 3. Equals 0.0 if generalized RE test.}

\item{N}{total number of observations}

\item{weights}{the vector of survey weights. Uniform by default.}
}
\value{
a list containing, in order:

 -  T_n : the test statistic

 - phi_n: the vector of coresponding GMS functions

 - M_bar : the matrix of M_bar  in  Section 3
}
\description{
This is an internal function used in the function test to compute the test statistic with survey weights.
}
\details{
By default, the test is implemented without covariates. To perform the test with covariates, one has to indicate in X a non-constant vector or matrix. Also, one can perform the « generalized » tests allowing for aggregate shocks by using the dummy variable generalized. Survey weights can be added. The user can modify the number of cores used by R to reduce the computational time. Tuning parameters used in the test can also be modified.
}
\references{
D’Haultfoeuille X, Gaillac C, Maurel A (2018). “Rationalizing Rational Expectations? Tests and Deviations.” CREST Working paper

Andrews D, Shi X (2017). “Inference Based on Many Conditional Moment Inequalities.” Journal of Econometrics, 196(2), 275–287.

Andrews DW, Kim W, Shi X (2017). “Commands for testing conditional moment inequalities and equalities.” The Stata journal, 17(1).
}
