\name{convertRank}
\alias{convertRank}
\title{change the representation of a rank}
\usage{
  convertRank(x)
}
\arguments{
  \item{x}{a rank (vector) datum either in its ranking or
  ordering representation.}
}
\value{
  a rank (vector) in its ordering representation if its
  ranking representation has been given in input of
  convertRank, and vice-versa.
}
\description{
  convertRank converts a rank from its ranking
  representation to its ordering representation, and
  vice-versa. The function does not work with partial
  ranking. The transformation to convert a rank from
  ordering to ranking representation is the same that from
  ranking to ordering representation, there is no need to
  precise the representation of rank x.
}
\details{
  The ranking representation r=(r_1,...,r_m) contains the
  ranks assigned to the objects, and means that the ith
  object is in r_ith position.

  The ordering representation o=(o_1,...,o_m) means that
  object o_i is in the ith position.

  Let us consider the following example to illustrate both
  notations: a judge, which has to rank three holidays
  destinations according to its preferences, O1 =
  Countryside, O2 =Mountain and O3 = Sea, ranks first Sea,
  second Countryside, and last Mountain. The ordering
  result of the judge is o = (3, 1, 2) whereas the ranking
  result is r = (2, 3, 1).
}
\examples{
x=c(2,3,1,4,5)
convertRank(x)
}
\author{
  Julien Jacques
}

