% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_convert.R
\name{lifetable_convert}
\alias{lifetable_convert}
\alias{lx_to_px}
\alias{lx_to_hx}
\alias{px_to_lx}
\alias{px_to_hx}
\alias{hx_to_lx}
\alias{hx_to_px}
\title{Convert between age-specific survivorship, survival, or mortality hazard}
\usage{
lx_to_px(lx)

lx_to_hx(lx)

px_to_lx(px)

px_to_hx(px)

hx_to_lx(hx)

hx_to_px(hx)
}
\arguments{
\item{lx}{Vector of age-specific survivorship.}

\item{px}{Vector of age-specific survival probabilities.}

\item{hx}{Vector of age-specific mortality hazards.}
}
\value{
A vector.
}
\description{
Convert between vectors of age-specific survivorship (lx), survival
probability (px), or mortality hazard (hx). Input vectors must be arranged in
order of increasing age, starting with age 0.
}
\details{
\code{lx} gives the proportional survivorship to the start of age
  class \code{x} (where survivorship at first age class is defined as 1),
  \code{px} gives the probability of survival between age \code{x} and
  \code{x+1}, and \code{hx} gives the time-averaged mortality hazard (also
  called force of mortality) between age \code{x} and \code{x+1}.
}
\examples{
lx <- c(1, 0.8, 0.7, 0.5, 0.3, 0.1)

# convert from lx
px <- lx_to_px(lx)
hx <- lx_to_hx(lx)

# convert from px
lx <- px_to_lx(px)
hx <- px_to_hx(px)

# convert from hx
lx <- hx_to_lx(hx)
px <- hx_to_px(hx)

}
\references{
Ergon, T., Borgan, Ø., Nater, C. R., & Vindenes, Y. 2018. The
  utility of mortality hazard rates in population analyses. Methods in
  Ecology and Evolution, 9, 2046-2056. <doi:10.1111/2041-210X.13059>
}
\seealso{
Other life tables: 
\code{\link{age_from_stage}},
\code{\link{mpm_to_table}()},
\code{\link{qsd_converge}()}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{life tables}
