% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_loadsave.R
\name{read.acmap}
\alias{read.acmap}
\title{Read in acmap data from a file}
\usage{
read.acmap(
  filename,
  optimization_number = NULL,
  sort_optimizations = FALSE,
  align_optimizations = FALSE
)
}
\arguments{
\item{filename}{Path to the file.}

\item{optimization_number}{Numeric vector of optimization runs to keep, the
default, NULL, keeps information on all optimization runs}

\item{sort_optimizations}{Should optimizations be sorted in order of stress
when the map data is read?}

\item{align_optimizations}{Should optimizations be rotated and translated to
match the orientation of the first optimization as closely as possible?}
}
\value{
Returns the acmap data object.
}
\description{
Reads an antigenic map file and converts it into an acmap data object.
}
\seealso{
Other functions for working with map data: 
\code{\link{acmap}()},
\code{\link{addOptimization}()},
\code{\link{agReactivityAdjustments}()},
\code{\link{as.json}()},
\code{\link{edit_agNames}()},
\code{\link{edit_srNames}()},
\code{\link{keepBestOptimization}()},
\code{\link{keepSingleOptimization}()},
\code{\link{layerNames}()},
\code{\link{orderPoints}},
\code{\link{read.titerTable}()},
\code{\link{removePoints}},
\code{\link{save.acmap}()},
\code{\link{save.coords}()},
\code{\link{save.titerTable}()},
\code{\link{subsetCommonPoints}},
\code{\link{subsetMap}()}
}
\concept{functions for working with map data}
