% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize_reactivity.R
\name{optimizeAgReactivity}
\alias{optimizeAgReactivity}
\title{Optimize antigen reactivity adjustments}
\usage{
optimizeAgReactivity(
  map,
  optimization_number = 1,
  reactivity_stress_weighting = 1,
  fixed_ag_reactivities = rep(NA, numAntigens(map)),
  start_pars = rep(0, numAntigens(map)),
  reoptimize = FALSE,
  number_of_optimizations = 100,
  options = list()
)
}
\arguments{
\item{map}{The acmap object}

\item{optimization_number}{The optimization number for which to optimize
antigen reactivity adjustments}

\item{reactivity_stress_weighting}{The weighting to apply when calculating
how much antigen reactivity changes should additionally contribute to
stress in the optimization regime (see details).}

\item{fixed_ag_reactivities}{A vector of fixed antigen reactivities,
use NA values to distinguish the positions you would still like to
be optimized.}

\item{start_pars}{A vector of starting parameters to use for the optimizer,
you can still supply starting parameters for antigens listed in
\code{fixed_ag_reactivities} but they will be ignored.}

\item{reoptimize}{Should the map be reoptimized from scratch (slower but
more likely to explore other optima) when testing each reactivity adjustment
or simply relaxed from it's current coordinates (default)}

\item{number_of_optimizations}{If reoptimizing from scratch, how many optimization
runs should be performed each time.}

\item{options}{A named list of additional options to pass to
\code{RacOptimizer.options()}}
}
\value{
The acmap object is returned with antigen reactivity adjustments
set to the value calculated in the optimizer. This can be queried with
\code{agReactivityAdjustments()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
