% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_optimize.R
\name{make.acmap}
\alias{make.acmap}
\title{Make an antigenic map from scratch}
\usage{
make.acmap(
  titer_table = NULL,
  ag_names = NULL,
  sr_names = NULL,
  number_of_dimensions = 2,
  number_of_optimizations = 100,
  minimum_column_basis = "none",
  fixed_column_bases = NULL,
  sort_optimizations = TRUE,
  check_convergence = TRUE,
  verbose = TRUE,
  options = list(),
  ...
)
}
\arguments{
\item{titer_table}{A table of titer data}

\item{ag_names}{A vector of antigen names}

\item{sr_names}{A vector of sera names}

\item{number_of_dimensions}{The number of dimensions in the map}

\item{number_of_optimizations}{The number of optimization runs to perform}

\item{minimum_column_basis}{The minimum column basis for the map}

\item{fixed_column_bases}{A vector of fixed values to use as column bases
directly, rather than calculating them from the titer table.}

\item{sort_optimizations}{Should optimizations be sorted by stress
afterwards?}

\item{check_convergence}{Should a basic check for convergence of lowest stress
optimization runs onto a similar solution be performed.}

\item{verbose}{Should progress messages be reported, see also
\code{RacOptimizer.options()}}

\item{options}{List of named optimizer options, see \code{RacOptimizer.options()}}

\item{...}{Further arguments to pass to \code{acmap()}}
}
\value{
Returns an acmap object that has optimization run results.
}
\description{
This is a wrapper function for first making a map with table data then,
running optimizations to make the map otherwise done with \code{acmap()}
followed by \code{optimizeMap()}.
}
\seealso{
Other map optimization functions: 
\code{\link{RacOptimizer.options}()},
\code{\link{moveTrappedPoints}()},
\code{\link{optimizeMap}()},
\code{\link{randomizeCoords}()},
\code{\link{relaxMapOneStep}()},
\code{\link{relaxMap}()}
}
\concept{map optimization functions}
