% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotMV}
\alias{plotMV}
\title{Plot of Mean-Variance dependence and various fits}
\usage{
plotMV(x, cv = FALSE, ret = FALSE, span = 0.75, degree = 2, ...)
}
\arguments{
\item{x}{Transcript count matrix.}

\item{cv}{Logical. If \code{TRUE} then the coefficient of variation is plotted instead of the variance. Default is \code{FALSE}.}

\item{ret}{Logical. If \code{TRUE} then a second order polynomial fit is returned. Default is \code{FALSE}}

\item{span}{Parameter for the local regression. See help(loess). Default value is 0.75.}

\item{degree}{Parameter for the local regression. See help(loess). Default value is 2.}

\item{...}{Additional arguments for \code{plot}.}
}
\value{
If \code{ret=FALSE} second order polynomial fit as returned by \code{lm}.
}
\description{
This functions plots the dependence of the transcript count variance or, alternatively, the coefficient of variation (CV) on the mean in log2 space. The  mean-variance dependence is plotted along with a loess-regression, a second order polynomial fit, and the background model of the local variability. The CV plot also highlights the local variability associated with cell-to-cell variability of total transcript counts, as calculated directly from the mean and variance of total transcript counts (turquoise) or from a local fit of a gamma distribution (orange).
}
