% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{extractCounts}
\alias{extractCounts}
\title{Function for filtering count data}
\usage{
extractCounts(
  object,
  minexpr = 5,
  minnumber = 5,
  noise = FALSE,
  pt = NULL,
  n = NULL,
  g = NULL,
  norm = TRUE
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{minexpr}{Integer number greater or equal to zero. Minimum expression of a gene in at least \code{minnumber} cells to not be discarded. Default is 5.}

\item{minnumber}{Integer number greater or equal to zero. Minimum number of cells required to have at least \code{minexpr} transcript counts for a gene to not be discarded. Default is 5.}

\item{noise}{logical. If \code{TRUE}, then noise (in \code{object@noise}) is returned for the filtered genes and cells. Default is \code{FALSE} and gene expression counts are returned.}

\item{pt}{List object returned by function \code{pseudoTime}. If given, then feature matrix is returned for cells in \code{pt$ord} and ordered by pseudo-time. Default is NULL and feature matrix is returned for all cells in \code{object$ndata}.}

\item{n}{Vector of valid column names corresponding to a subset of valid column names of the \code{object@ndata}. Default is \code{NULL} filtering is done on all cells in \code{object@ndata}. Only considered if \code{pt} is NULL.}

\item{g}{Vector of gene IDs (valid row names of \code{object@ndata}). If given, then all genes not in \code{g} are discarded prior to filtering. Default is NULL and filtering is done on all genes in \code{object@ndata}.}

\item{norm}{logical. If \code{TRUE}, then transcipt counts are normalized to the minimum number of total transcript counts across all cells in the feature matrix.}
}
\value{
Filtered expression matrix.
}
\description{
This function discards lowly expressed genes from a count matrix stored in an \code{SCseq} object, and returns (normalized or non-normalized) gene expression or noise values.
}
