% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{diffNoisyGenes}
\alias{diffNoisyGenes}
\title{Function for extracting genes with elevated variability in a cluster}
\usage{
diffNoisyGenes(noise, cl, set, bgr = NULL, no_cores = 1)
}
\arguments{
\item{noise}{List object with the background noise model and a variability matrix, returned by the \code{compNoise} function.}

\item{cl}{List object with Louvain clustering information, returned by the \code{graphCluster} function.}

\item{set}{Postive integer number or vector of integers corresponding to valid cluster numbers. The function reports genes with elevated variability in all
clusters contained in \code{set}.}

\item{bgr}{Postive integer number or vector of integers corresponding to valid cluster numbers. Background set for comparison. The function reports genes
with elevated variability in all clusters contained in \code{set} compared to clusters in \code{bgr}. Default is \code{NULL} and the comparison is against all
clusters not in \code{set}.}

\item{no_cores}{Positive integer number. Number of cores for multithreading. If set to \code{NULL} then the number of available cores minus two is used. Default is 1.}
}
\value{
Data.frame reporting the log2 fold change between clusters in \code{set} and the remaining clusters and the p-value for elevated variability for each genes. Rows are ordered by decreasing log2 fold change.
}
\description{
This function extracts genes with significantly elevated variability in a cluster on a basis of a Wilcoxon rank sum-test between cells in a cluster
and all remaining cells.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compNoise(intestinalDataSmall,res,pvalue=0.01,genes = NULL,no_cores=1)
cl <- graphCluster(res,pvalue=0.01)
ngenes <- diffNoisyGenes(noise,cl,c(1,2),no_cores=1)
}
