% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{fitBackVar}
\alias{fitBackVar}
\title{Function for computing a background model of gene expression variability}
\usage{
fitBackVar(x, mthr = -1)
}
\arguments{
\item{x}{Matrix of gene expression values with genes as rows and cells as columns.}

\item{mthr}{Real number. Threshold of log2 mean expression. Genes with mean expression \code{< mthr} are discarded prior to fitting the polynomial. Default is -1.}
}
\value{
List object of four components:
\item{fit}{model fit as returned by the \code{lm} function.}
\item{genes}{genes with expression variance greater than the polynomial fit.}
\item{m}{mean expression of all genes}
\item{v}{expression variance of all genes}
}
\description{
This funtion fits a second order polynomial to the variance-mean dependence across all genes in log space.
}
\examples{
bg <- fitBackVar(intestinalDataSmall)
}
