% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{findoutliers}
\alias{findoutliers}
\title{Inference of outlier cells and final clustering}
\usage{
findoutliers(
  object,
  probthr = 0.001,
  outminc = 5,
  outlg = 2,
  outdistquant = 0.95,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{probthr}{outlier probability threshold for a minimum of \code{outlg} genes to be an outlier cell. This probability is computed from a negative binomial
background model of expression in a cluster. Default is 0.001.}

\item{outminc}{minimal transcript count of a gene in a clusters to be tested for being an outlier gene. Default is 5.}

\item{outlg}{Minimum number of outlier genes required for being an outlier cell. Default is 2.}

\item{outdistquant}{Real number between zero and one. Outlier cells are merged to outlier clusters if their distance smaller than the outdistquant-quantile of
the distance distribution of  pairs of cells in the orginal clusters after outlier removal. Default is 0.95.}

\item{verbose}{logical. If \code{FALSE} then status output messages are disabled. Default is \code{TRUE}.}
}
\value{
\code{SCseq} object with outlier data stored in slot \code{out} and slot \code{outlierpar}. The final clustering partition is stored in
\code{cpart}.
}
\description{
This functions performs the outlier identification based on the clusters infered with the \code{clustexp} function.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
sc <- clustexp(sc)
sc <- findoutliers(sc)
}
