% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{updateSC}
\alias{updateSC}
\title{Function for updating a RaceID SCseq object with VarID results}
\usage{
updateSC(object, res = NULL, cl = NULL, noise = NULL, flo = NULL)
}
\arguments{
\item{object}{\pkg{RaceID} \code{SCseq} object.}

\item{res}{List object returned by \code{pruneKnn} function to update \code{SCseq} with distance matrix and/or dimensionally reduced feature matrix
in \code{res}. Default is \code{NULL}}

\item{cl}{List object with Louvain clustering information, returned by the \code{graphCluster} function to update \code{SCseq} object with clustering
partition and Fruchterman-Rheingold layout. Default is \code{NULL}.}

\item{noise}{List object with the background noise model and a variability matrix, returned by the \code{compNoise} function, to update \code{SCseq}
object with a noise matrix. Default is \code{NULL}.}

\item{flo}{Real number. Lower cutoff for the gene expression variability. All values \code{< flo} in the variability matrix are set to this level. Default is \code{NULL} and values are not reset.}
}
\value{
\code{SCseq} object with a distance matrix (slot \code{distances}) and a dimensionally reduced feature matrix (slot \code{dimRed$x}), or clustering partition (slot \code{cpart} and \code{cluster$kpart}) derived from the VarID analysis, and/or with a gene expression variability matrix in slot \code{noise}.
}
\description{
This function updates a \pkg{RaceID} \code{SCseq} object with a distance matrix or dimensionally reduced feature matrix,
a clustering partition, and/or a matrix of gene expression variability,
in order to utilize \pkg{RaceID} functions for visualization.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
d <- getExpData(sc)
res <- pruneKnn(d,distM=sc@distances,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
cl <- graphCluster(res,pvalue=0.01)
sc <- updateSC(sc,res=res,cl=cl)
sc <- comptsne(sc)
plotmap(sc)
}
