% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{maxNoisyGenes}
\alias{maxNoisyGenes}
\title{Function for extracting genes maximal variability}
\usage{
maxNoisyGenes(noise, cl = NULL, set = NULL)
}
\arguments{
\item{noise}{List object with the background noise model and a variability matrix, returned by the \code{compNoise} function.}

\item{cl}{List object with Louvain clustering information, returned by the \code{graphCluster} function. Default is \code{NULL}.}

\item{set}{Postive integer number or vector of integers corresponding to valid cluster numbers. Default is \code{NULL}}
}
\value{
Vector with average gene expression variability in decreasing order, computed across all cells or only cells in a set of clusters (if \code{cl} and
\code{set} are given.
}
\description{
This function extracts genes with maximal variability in a cluster or in the entire data set.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compNoise(intestinalDataSmall,res,pvalue=0.01,genes = NULL,no_cores=1)
mgenes <- maxNoisyGenes(noise)
}
