% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzmlFunctions.R
\name{grabMzmlBPC}
\alias{grabMzmlBPC}
\title{Grab the BPC or TIC from a file}
\usage{
grabMzmlBPC(xml_data, rtrange, TIC = FALSE)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzML file.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{TIC}{Boolean. If TRUE, the TIC is extracted rather than the BPC.}
}
\value{
A `data.table` with columns for retention time (rt), and intensity
  (int).
}
\description{
The base peak intensity and total ion current are actually written into the
mzML files and aren't encoded, making retrieval of BPC and TIC information
blazingly fast if parsed correctly.
}
