library(testthat)
library(RZooRoH)

#test_check("RZooRoH")
context("Running")

test_that("Running one BBB with 1R model ...",{
  my.mod1R <- zoomodel(predefined=FALSE,K=2,krates=c(10,10))
  freqfile <- (system.file("exdata","typsfrq.txt",package="RZooRoH"))
  typfile <- (system.file("exdata","typs.txt",package="RZooRoH"))
  frq <- read.table(freqfile,header=FALSE)
  bbb <- zoodata(typfile,supcol=4,chrcol=1,poscol=2,allelefreq=frq$V1)
  bbb_results <- zoorun(my.mod1R, bbb, ids = c(1))
  expect_equal(round(bbb_results@modlik[1],1),-6127.2)
  expect_equal(round(bbb_results@realized[1,1],3),0.059)
  expect_equal(round(bbb_results@krates[1,1],1),73.3)
  expect_equal(round(bbb_results@mixc[1,1],3),0.058)
  expect_equal(dim(bbb_results@hbdseg)[1],12)
})

test_that("Running two BBB with 1R model and EM algorithm ...",{
  my.mod1R <- zoomodel(predefined=FALSE,K=2,krates=c(10,10))
  freqfile <- (system.file("exdata","typsfrq.txt",package="RZooRoH"))
  typfile <- (system.file("exdata","typs.txt",package="RZooRoH"))
  frq <- read.table(freqfile,header=FALSE)
  bbb <- zoodata(typfile,supcol=4,chrcol=1,poscol=2,allelefreq=frq$V1)
  bbb_results2 <- zoorun(my.mod1R, bbb, method="estem",ids = c(1,2), convem=1e-12,
                         maxiter=100, minr=2, maxr=100)
  expect_equal(round(bbb_results2@modlik[1],1),-6128.6)
  expect_equal(round(bbb_results2@modlik[2],1),-5767.7)
  expect_equal(round(bbb_results2@realized[1,1],3),0.051)
  expect_equal(round(bbb_results2@krates[1,1],1),48.9)
  expect_equal(dim(bbb_results2@hbdseg)[1],16)
})

test_that("Running with local HBD probabilities ...",{
  my.mod1R <- zoomodel(predefined=FALSE,K=2,krates=c(10,10))
  freqfile <- (system.file("exdata","typsfrq.txt",package="RZooRoH"))
  typfile <- (system.file("exdata","typs.txt",package="RZooRoH"))
  frq <- read.table(freqfile,header=FALSE)
  bbb <- zoodata(typfile,supcol=4,chrcol=1,poscol=2,allelefreq=frq$V1)
  bbb_results3 <- zoorun(my.mod1R, bbb, localhbd = TRUE)
  expect_equal(round(min(bbb_results3@hbdp[[1]][1,1:100]),3),0)
  expect_equal(round(min(bbb_results3@hbdp[[2]][1,1:100]),3),0)
  expect_equal(round(min(bbb_results3@hbdp[[3]][1,1:100]),3),0)
  expect_equal(round(min(bbb_results3@hbdp[[4]][1,1:100]),3),0)
  expect_equal(round(min(bbb_results3@hbdp[[5]][1,1:100]),3),0)
  expect_equal(round(max(bbb_results3@hbdp[[1]][1,1:100]),3),0.81)
  expect_equal(round(max(bbb_results3@hbdp[[2]][1,1:100]),3),0.002)
  expect_equal(round(max(bbb_results3@hbdp[[3]][1,1:100]),3),0.05)
  expect_equal(round(max(bbb_results3@hbdp[[4]][1,1:100]),3),0.057)
  expect_equal(round(max(bbb_results3@hbdp[[5]][1,1:100]),3),0.237)
})

test_that("Running with MixKR model ...",{
  freqfile <- (system.file("exdata","typsfrq.txt",package="RZooRoH"))
  typfile <- (system.file("exdata","typs.txt",package="RZooRoH"))
  frq <- read.table(freqfile,header=FALSE)
  bbb <- zoodata(typfile,supcol=4,chrcol=1,poscol=2,allelefreq=frq$V1)
  Mod3R <- zoomodel(K=3,base_rate=10)
  bbb_mod3r <- zoorun(Mod3R, bbb, localhbd = TRUE)
  expect_equal(round(bbb_mod3r@modlik[1],1),-6128.1)
  expect_equal(round(bbb_mod3r@realized[6,1],3),0.100)
  expect_equal(round(bbb_mod3r@realized[1,2],3),0.063)
  expect_equal(round(bbb_mod3r@realized[3,3],3),0.948)
  expect_equal(round(bbb_mod3r@krates[1,1],1),10)
  expect_equal(round(bbb_mod3r@mixc[1,2],3),0.060)
  expect_equal(round(bbb_mod3r@mixc[2,3],3),0.990)
  expect_equal(dim(bbb_mod3r@hbdseg)[1],45)
  expect_equal(max(bbb_mod3r@hbdseg$number_snp),145)
  expect_equal(max(bbb_mod3r@hbdseg$length),48659487)
  expect_equal(round(min(bbb_mod3r@hbdp[[1]][2,1:100]),3),0)
  expect_equal(round(min(bbb_mod3r@hbdp[[2]][2,1:100]),3),0)
  expect_equal(round(min(bbb_mod3r@hbdp[[3]][2,1:100]),3),0)
  expect_equal(round(min(bbb_mod3r@hbdp[[4]][2,1:100]),3),0)
  expect_equal(round(min(bbb_mod3r@hbdp[[5]][2,1:100]),3),0)
  expect_equal(round(max(bbb_mod3r@hbdp[[1]][2,1:100]),3),0.845)
  expect_equal(round(max(bbb_mod3r@hbdp[[2]][2,1:100]),3),0.014)
  expect_equal(round(max(bbb_mod3r@hbdp[[3]][2,1:100]),3),0.138)
  expect_equal(round(max(bbb_mod3r@hbdp[[4]][2,1:100]),3),0.149)
  expect_equal(round(max(bbb_mod3r@hbdp[[5]][2,1:100]),3),0.225)
})

