% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_unload_all.R
\name{p_unload_all}
\alias{p_unload_all}
\title{Unload all non-base and non-recommended packages from the namespace}
\usage{
p_unload_all(unload = FALSE, crandb = get("crandb", envir = .GlobalEnv))
}
\arguments{
\item{unload}{logical. \code{FALSE} prints a list with 3 items: the loaded
packages, the packages in the namespace, the loaded DLLs.
\code{TRUE} removes the packages and their DLLs, then prints
the refreshed list.}

\item{crandb}{data.frame \code{crandb}.}
}
\description{
\code{p_unload_all} unloads in a safe order all packages, except the base and
recommended packages, that are attached or loaded in the namespace, plus their
respective DLLs.

It must be used before installing new versions of packages that are currently
loaded in the namespace and require some forced unloading, as revealed by the
first column of the data.frame produced by \code{\link{p_vers_deps}}. Warning:
this function also removes RWsearch and its dependencies. It is therefore
recommended to perform the installation with \code{\link{install.packages}}
rather than \code{\link{p_inst}}.

This function is safe enough to reinstall locked packages but not safe enough
for a further use as it does not unload the S3 and S4 classes nor the documentation
which is detected as corrupted. It is therefore recommend to stop and restart R
after the installation of the fresh packages.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory
## with functions crandb_down() or crandb_load().
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

p_unload_all()
## Then run p_unload_all(TRUE), but only for maintenance!

}
