/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Macro;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;

public class IfElseMacro
implements MacroDeclarations,
Macro {
    private static final String IF_ELSE = "ifelse";

    @Override
    public boolean hasMacro(String name) {
        return IF_ELSE.equals(name);
    }

    @Override
    public Macro getMacro(String name) {
        if (IF_ELSE.equals(name)) {
            return this;
        }
        throw new RuntimeException("Undefined Macro '" + name + "'!");
    }

    @Override
    public Node evaluate(Node ... params) throws SemanticException {
        if (params.length != 3) {
            throw new SemanticException("ifelse takes exactly 3 arguments!");
        }
        if (!(params[0] instanceof Primitives.BooleanExpression)) {
            throw new SemanticException("ifelse's first parameter must be boolean!");
        }
        if (params[1] instanceof Primitives.BooleanExpression && params[2] instanceof Primitives.BooleanExpression) {
            return new BooleanIfElse((Primitives.BooleanExpression)params[0], (Primitives.BooleanExpression)params[1], (Primitives.BooleanExpression)params[2]);
        }
        if (params[1] instanceof Primitives.DoubleExpression && params[2] instanceof Primitives.DoubleExpression) {
            return new DoubleIfElse((Primitives.BooleanExpression)params[0], (Primitives.DoubleExpression)params[1], (Primitives.DoubleExpression)params[2]);
        }
        if (params[1] instanceof Primitives.StringExpression && params[2] instanceof Primitives.StringExpression) {
            return new StringIfElse((Primitives.BooleanExpression)params[0], (Primitives.StringExpression)params[1], (Primitives.StringExpression)params[2]);
        }
        throw new SemanticException("ifelse's second and third parameter must be doubles, booleans or Strings!");
    }

    private static class StringIfElse
    implements Primitives.StringExpression {
        private final Primitives.BooleanExpression condition;
        private final Primitives.StringExpression ifPart;
        private final Primitives.StringExpression elsePart;

        public StringIfElse(Primitives.BooleanExpression condition, Primitives.StringExpression ifPart, Primitives.StringExpression elsePart) {
            this.condition = condition;
            this.ifPart = ifPart;
            this.elsePart = elsePart;
        }

        @Override
        public String evaluate() {
            if (this.condition.evaluate()) {
                return this.ifPart.evaluate();
            }
            return this.elsePart.evaluate();
        }
    }

    private static class BooleanIfElse
    implements Primitives.BooleanExpression {
        private final Primitives.BooleanExpression condition;
        private final Primitives.BooleanExpression ifPart;
        private final Primitives.BooleanExpression elsePart;

        public BooleanIfElse(Primitives.BooleanExpression condition, Primitives.BooleanExpression ifPart, Primitives.BooleanExpression elsePart) {
            this.condition = condition;
            this.ifPart = ifPart;
            this.elsePart = elsePart;
        }

        @Override
        public boolean evaluate() {
            if (this.condition.evaluate()) {
                return this.ifPart.evaluate();
            }
            return this.elsePart.evaluate();
        }
    }

    private static class DoubleIfElse
    implements Primitives.DoubleExpression {
        private final Primitives.BooleanExpression condition;
        private final Primitives.DoubleExpression ifPart;
        private final Primitives.DoubleExpression elsePart;

        public DoubleIfElse(Primitives.BooleanExpression condition, Primitives.DoubleExpression ifPart, Primitives.DoubleExpression elsePart) {
            this.condition = condition;
            this.ifPart = ifPart;
            this.elsePart = elsePart;
        }

        @Override
        public double evaluate() {
            if (this.condition.evaluate()) {
                return this.ifPart.evaluate();
            }
            return this.elsePart.evaluate();
        }
    }
}

