/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import weka.core.WekaPackageClassLoaderManager;

public class PluginManager {
    protected static Map<String, Map<String, String>> PLUGINS = new HashMap<String, Map<String, String>>();
    protected static Set<String> DISABLED = new HashSet<String>();
    protected static Map<String, Map<String, String>> RESOURCES = new HashMap<String, Map<String, String>>();
    protected static Map<String, String> RESOURCE_OWNER_PACKAGE = new HashMap<String, String>();

    public static synchronized void addToDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.addToDisabledList(s);
        }
    }

    public static synchronized void addToDisabledList(String classname) {
        DISABLED.add(classname);
    }

    public static synchronized void removeFromDisabledList(List<String> classnames) {
        for (String s : classnames) {
            PluginManager.removeFromDisabledList(s);
        }
    }

    public static synchronized void removeFromDisabledList(String classname) {
        DISABLED.remove(classname);
    }

    public static boolean isInDisabledList(String classname) {
        return DISABLED.contains(classname);
    }

    public static synchronized void addFromProperties(File propsFile) throws Exception {
        PluginManager.addFromProperties(null, propsFile);
    }

    public static synchronized void addFromProperties(String packageName, File propsFile) throws Exception {
        PluginManager.addFromProperties(packageName, propsFile, false);
    }

    public static synchronized void addFromProperties(File propsFile, boolean maintainInsertionOrder) throws Exception {
        PluginManager.addFromProperties(null, propsFile, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(String packageName, File propsFile, boolean maintainInsertionOrder) throws Exception {
        BufferedInputStream bi = new BufferedInputStream(new FileInputStream(propsFile));
        PluginManager.addFromProperties(packageName, bi, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(InputStream propsStream) throws Exception {
        PluginManager.addFromProperties(null, propsStream);
    }

    public static synchronized void addFromProperties(String packageName, InputStream propsStream) throws Exception {
        PluginManager.addFromProperties(packageName, propsStream, false);
    }

    public static synchronized void addFromProperties(InputStream propsStream, boolean maintainInsertionOrder) throws Exception {
        PluginManager.addFromProperties(null, propsStream, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(String packageName, InputStream propsStream, boolean maintainInsertionOrder) throws Exception {
        Properties expProps = new Properties();
        expProps.load(propsStream);
        propsStream.close();
        propsStream = null;
        PluginManager.addFromProperties(packageName, expProps, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(Properties props) throws Exception {
        PluginManager.addFromProperties(props, false);
    }

    public static synchronized void addFromProperties(String packageName, Properties props) throws Exception {
        PluginManager.addFromProperties(packageName, props, false);
    }

    public static synchronized void addFromProperties(Properties props, boolean maintainInsertionOrder) throws Exception {
        PluginManager.addFromProperties(null, props, maintainInsertionOrder);
    }

    public static synchronized void addFromProperties(String packageName, Properties props, boolean maintainInsertionOrder) throws Exception {
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String[] parts;
            String baseType = (String)keys.nextElement();
            String implementations = props.getProperty(baseType);
            if (baseType.equalsIgnoreCase("*resources*")) {
                PluginManager.addPluginResourcesFromProperty(packageName, implementations);
                continue;
            }
            if (implementations == null || implementations.length() <= 0) continue;
            for (String impl : parts = implementations.split(",")) {
                String name = impl = impl.trim();
                if (impl.charAt(0) == '[') {
                    name = impl.substring(1, impl.indexOf(93));
                    impl = impl.substring(impl.indexOf(93) + 1);
                }
                PluginManager.addPlugin(baseType, name.trim(), impl, maintainInsertionOrder);
            }
        }
    }

    public static void addPluginResourcesFromProperty(String resourceList) {
        PluginManager.addPluginResourcesFromProperty(null, resourceList);
    }

    protected static synchronized void addPluginResourcesFromProperty(String packageName, String resourceList) {
        String[] resources;
        for (String r : resources = resourceList.split(",")) {
            if (!(r = r.trim()).startsWith("[") || !r.endsWith("]")) {
                System.err.println("[PluginManager] Malformed resource in: " + resourceList);
                continue;
            }
            String[] rParts = (r = r.replace("[", "").replace("]", "")).split("\\|");
            if (rParts.length != 3) {
                System.err.println("[PluginManager] Was expecting 3 pipe separated parts in resource spec: " + r);
                continue;
            }
            String groupID = rParts[0].trim();
            String resourceDesc = rParts[1].trim();
            String resourcePath = rParts[2].trim();
            if (groupID.length() == 0 || resourceDesc.length() == 0 || resourcePath.length() == 0) {
                System.err.println("[PluginManager] Empty part in resource spec: " + r);
                continue;
            }
            PluginManager.addPluginResource(packageName, groupID, resourceDesc, resourcePath);
        }
    }

    public static void addPluginResource(String resourceGroupID, String resourceDescription, String resourcePath) {
        PluginManager.addPluginResource(null, resourceGroupID, resourceDescription, resourcePath);
    }

    public static synchronized void addPluginResource(String packageName, String resourceGroupID, String resourceDescription, String resourcePath) {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        if (groupMap == null) {
            groupMap = new LinkedHashMap<String, String>();
            RESOURCES.put(resourceGroupID, groupMap);
        }
        groupMap.put(resourceDescription, resourcePath);
        if (packageName != null && packageName.length() > 0) {
            RESOURCE_OWNER_PACKAGE.put(resourceGroupID + ":" + resourceDescription, packageName);
        }
    }

    public static InputStream getPluginResourceAsStream(String resourceGroupID, String resourceDescription) throws IOException {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        if (groupMap == null) {
            throw new IOException("Unknown resource group ID: " + resourceGroupID);
        }
        String resourcePath = groupMap.get(resourceDescription);
        if (resourcePath == null) {
            throw new IOException("Unknown resource: " + resourceDescription);
        }
        String ownerPackage = RESOURCE_OWNER_PACKAGE.get(resourceGroupID + ":" + resourceDescription);
        if (ownerPackage == null) {
            return PluginManager.class.getClassLoader().getResourceAsStream(resourcePath);
        }
        return WekaPackageClassLoaderManager.getWekaPackageClassLoaderManager().getPackageClassLoader(ownerPackage).getResourceAsStream(resourcePath);
    }

    public static int numResourcesForWithGroupID(String resourceGroupID) {
        Map<String, String> groupMap = RESOURCES.get(resourceGroupID);
        return groupMap == null ? 0 : groupMap.size();
    }

    public static Map<String, String> getResourcesWithGroupID(String resourceGroupID) {
        return RESOURCES.get(resourceGroupID);
    }

    public static Set<String> getPluginNamesOfType(String interfaceName) {
        if (PLUGINS.get(interfaceName) != null) {
            Set<String> match = PLUGINS.get(interfaceName).keySet();
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String s : match) {
                String impl = PLUGINS.get(interfaceName).get(s);
                if (DISABLED.contains(impl)) continue;
                result.add(s);
            }
            return result;
        }
        return null;
    }

    public static void addPlugin(String interfaceName, String name, String concreteType) {
        PluginManager.addPlugin(interfaceName, name, concreteType, false);
    }

    public static void addPlugin(String interfaceName, String name, String concreteType, boolean maintainInsertionOrder) {
        if (PLUGINS.get(interfaceName) == null) {
            AbstractMap pluginsOfInterfaceType = maintainInsertionOrder ? new LinkedHashMap() : new TreeMap();
            pluginsOfInterfaceType.put(name, concreteType);
            PLUGINS.put(interfaceName, pluginsOfInterfaceType);
        } else {
            PLUGINS.get(interfaceName).put(name, concreteType);
        }
    }

    public static void removePlugins(String interfaceName, List<String> names) {
        for (String name : names) {
            PluginManager.removePlugin(interfaceName, name);
        }
    }

    public static void removePlugin(String interfaceName, String name) {
        if (PLUGINS.get(interfaceName) != null) {
            PLUGINS.get(interfaceName).remove(name);
        }
    }

    public static boolean pluginRegistered(String interfaceType, String name) {
        Map<String, String> pluginsOfInterfaceType = PLUGINS.get(interfaceType);
        return pluginsOfInterfaceType.get(name) != null;
    }

    public static Object getPluginInstance(String interfaceType, String name) throws Exception {
        if (PLUGINS.get(interfaceType) == null || PLUGINS.get(interfaceType).size() == 0) {
            throw new Exception("No plugins of interface type: " + interfaceType + " available!!");
        }
        Map<String, String> pluginsOfInterfaceType = PLUGINS.get(interfaceType);
        if (pluginsOfInterfaceType.get(name) == null) {
            throw new Exception("Can't find named plugin '" + name + "' of type '" + interfaceType + "'!");
        }
        String concreteImpl = pluginsOfInterfaceType.get(name);
        Object plugin = null;
        if (!DISABLED.contains(concreteImpl)) {
            plugin = WekaPackageClassLoaderManager.forName(concreteImpl).newInstance();
        }
        return plugin;
    }
}

