/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.CommandlineRunnable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ListOptions
implements OptionHandler,
RevisionHandler,
CommandlineRunnable {
    protected String m_Classname = ListOptions.class.getName();

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe class to load.", "W", 1, "-W <classname>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('W', options);
        if (tmpStr.length() > 0) {
            this.setClassname(tmpStr);
        } else {
            this.setClassname(this.getClass().getName());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-W");
        result.add(this.getClassname());
        return result.toArray(new String[result.size()]);
    }

    public void setClassname(String value) {
        this.m_Classname = value;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String generateHelp() {
        String result = this.getClass().getName().replaceAll(".*\\.", "") + " Options:\n\n";
        Enumeration<Option> enm = this.listOptions();
        while (enm.hasMoreElements()) {
            Option option = enm.nextElement();
            result = result + option.synopsis() + "\n" + option.description() + "\n";
        }
        return result;
    }

    public String generate() throws Exception {
        StringBuffer result = new StringBuffer();
        OptionHandler handler = (OptionHandler)Utils.forName(null, this.getClassname(), new String[0]);
        Enumeration<Option> enm = handler.listOptions();
        while (enm.hasMoreElements()) {
            Option option = enm.nextElement();
            result.append(option.synopsis() + '\n');
            result.append(option.description() + "\n");
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12947 $");
    }

    public static void main(String[] options) {
        try {
            ListOptions lo = new ListOptions();
            lo.run(lo, options);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void run(Object toRun, String[] options) throws Exception {
        if (!(toRun instanceof ListOptions)) {
            throw new IllegalArgumentException("Object to run is not an instance of ListOptions!");
        }
        ListOptions list = (ListOptions)toRun;
        try {
            try {
                if (Utils.getFlag('h', options)) {
                    throw new Exception("Help requested");
                }
                list.setOptions(options);
                Utils.checkForRemainingOptions(options);
            }
            catch (Exception ex) {
                String result = "\n" + ex.getMessage() + "\n\n" + list.generateHelp();
                throw new Exception(result);
            }
            System.out.println("\n" + list.generate());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public void postExecution() throws Exception {
    }
}

