/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import weka.gui.InteractiveTableModel;
import weka.gui.InteractiveTablePanel;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.knowledgeflow.steps.SetVariables;

public class SetVariablesStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = 5747505623497131129L;
    protected VariablesPanel m_vp;

    @Override
    protected void layoutEditor() {
        String internalRep = ((SetVariables)this.getStepToEdit()).getVarsInternalRep();
        Map<String, String> vars = SetVariables.internalToMap(internalRep);
        this.m_vp = new VariablesPanel(vars);
        this.add((Component)this.m_vp, "Center");
    }

    @Override
    protected void okPressed() {
        String vi = this.m_vp.getVariablesInternal();
        ((SetVariables)this.getStepToEdit()).setVarsInternalRep(this.m_vp.getVariablesInternal());
    }

    protected static class VariablesPanel
    extends JPanel {
        private static final long serialVersionUID = 5188290550108775006L;
        protected InteractiveTablePanel m_table = new InteractiveTablePanel(new String[]{"Variable", "Value", ""});

        public VariablesPanel(Map<String, String> vars) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder("Variables to set"));
            this.add((Component)this.m_table, "Center");
            int row = 0;
            JTable table = this.m_table.getTable();
            for (Map.Entry<String, String> e : vars.entrySet()) {
                String varName = e.getKey();
                String varVal = e.getValue();
                if (varVal == null || varVal.length() <= 0) continue;
                table.getModel().setValueAt(varName, row, 0);
                table.getModel().setValueAt(varVal, row, 1);
                ((InteractiveTableModel)table.getModel()).addEmptyRow();
                ++row;
            }
        }

        public String getVariablesInternal() {
            StringBuilder b = new StringBuilder();
            JTable table = this.m_table.getTable();
            int numRows = table.getModel().getRowCount();
            for (int i = 0; i < numRows; ++i) {
                String paramName = table.getValueAt(i, 0).toString();
                String paramValue = table.getValueAt(i, 1).toString();
                if (paramName.length() > 0 && paramValue.length() > 0) {
                    b.append(paramName).append("@v@v").append(paramValue);
                }
                if (i >= numRows - 1) continue;
                b.append("@@vv@@");
            }
            return b.toString();
        }
    }
}

