/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import weka.core.PluginManager;
import weka.core.Utils;
import weka.core.WekaException;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.beans.KFIgnore;
import weka.gui.knowledgeflow.InvisibleNode;
import weka.gui.knowledgeflow.InvisibleTreeModel;
import weka.gui.knowledgeflow.MainKFPerspective;
import weka.gui.knowledgeflow.StepTreeIgnore;
import weka.gui.knowledgeflow.StepTreeLeafDetails;
import weka.gui.knowledgeflow.StepVisual;
import weka.gui.knowledgeflow.VisibleLayout;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;
import weka.knowledgeflow.steps.WekaAlgorithmWrapper;

public class StepTree
extends JTree {
    protected static final String STEP_LIST_PROPS = "weka/knowledgeflow/steps/steps.props";
    private static final long serialVersionUID = 3646119269455293741L;
    protected MainKFPerspective m_mainPerspective;
    protected Map<String, DefaultMutableTreeNode> m_nodeTextIndex = new HashMap<String, DefaultMutableTreeNode>();

    public StepTree(MainKFPerspective mainPerspective) {
        this.m_mainPerspective = mainPerspective;
        DefaultMutableTreeNode jtreeRoot = new DefaultMutableTreeNode("Weka");
        InvisibleTreeModel model = new InvisibleTreeModel(jtreeRoot);
        model.activateFilter(true);
        this.setModel(model);
        this.setEnabled(true);
        this.setToolTipText("");
        this.setShowsRootHandles(true);
        this.setCellRenderer(new StepIconRenderer());
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.setSelectionModel(selectionModel);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object userObject;
                DefaultMutableTreeNode tNode;
                TreePath p;
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    StepTree.this.m_mainPerspective.setFlowLayoutOperation(VisibleLayout.LayoutOperation.NONE);
                    StepTree.this.m_mainPerspective.setPalleteSelectedStep(null);
                    StepTree.this.m_mainPerspective.setCursor(Cursor.getPredefinedCursor(0));
                    StepTree.this.clearSelection();
                }
                if ((p = StepTree.this.getSelectionPath()) != null && p.getLastPathComponent() instanceof DefaultMutableTreeNode && (tNode = (DefaultMutableTreeNode)p.getLastPathComponent()).isLeaf() && (userObject = tNode.getUserObject()) instanceof StepTreeLeafDetails) {
                    try {
                        StepVisual visual = ((StepTreeLeafDetails)userObject).instantiateStep();
                        StepTree.this.m_mainPerspective.setCursor(Cursor.getPredefinedCursor(1));
                        if (StepTree.this.m_mainPerspective.getDebug()) {
                            System.err.println("Instantiated " + visual.getStepName());
                        }
                        StepTree.this.m_mainPerspective.setPalleteSelectedStep(visual.getStepManager());
                    }
                    catch (Exception ex) {
                        StepTree.this.m_mainPerspective.showErrorDialog(ex);
                    }
                }
            }
        });
        try {
            this.populateTree(jtreeRoot);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.expandRow(0);
        this.setRootVisible(false);
    }

    protected void populateTree(DefaultMutableTreeNode jtreeRoot) throws Exception {
        Properties GOEProps = this.initGOEProps();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(STEP_LIST_PROPS);
        Properties builtinSteps = new Properties();
        builtinSteps.load(inputStream);
        inputStream.close();
        inputStream = null;
        String stepClassNames = builtinSteps.getProperty("weka.knowledgeflow.steps.Step");
        String[] s = stepClassNames.split(",");
        LinkedHashSet<String> stepImpls = new LinkedHashSet<String>();
        stepImpls.addAll(Arrays.asList(s));
        this.populateTree(stepImpls, jtreeRoot, GOEProps);
        Set<String> stepClasses = PluginManager.getPluginNamesOfType("weka.knowledgeflow.steps.Step");
        if (stepClasses != null && stepClasses.size() > 0) {
            LinkedHashSet<String> filteredStepClasses = new LinkedHashSet<String>();
            for (String plugin : stepClasses) {
                if (stepClassNames.contains(plugin)) continue;
                filteredStepClasses.add(plugin);
            }
            this.populateTree(filteredStepClasses, jtreeRoot, GOEProps);
        }
    }

    protected void populateTree(Set<String> stepClasses, DefaultMutableTreeNode jtreeRoot, Properties GOEProps) throws Exception {
        for (String stepClass : stepClasses) {
            try {
                Step toAdd = (Step)Beans.instantiate(this.getClass().getClassLoader(), stepClass);
                if (toAdd.getClass().getAnnotation(StepTreeIgnore.class) != null || toAdd.getClass().getAnnotation(KFIgnore.class) != null) continue;
                String category = this.getStepCategory(toAdd);
                DefaultMutableTreeNode targetFolder = this.getCategoryFolder(jtreeRoot, category);
                if (toAdd instanceof WekaAlgorithmWrapper) {
                    this.populateForWekaWrapper(targetFolder, (WekaAlgorithmWrapper)toAdd, GOEProps);
                    continue;
                }
                StepTreeLeafDetails leafData = new StepTreeLeafDetails(toAdd);
                InvisibleNode fixedLeafNode = new InvisibleNode(leafData);
                targetFolder.add(fixedLeafNode);
                String tipText = leafData.getToolTipText() != null ? leafData.getToolTipText() : "";
                this.m_nodeTextIndex.put(stepClass.toLowerCase() + " " + tipText, fixedLeafNode);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void populateForWekaWrapper(DefaultMutableTreeNode targetFolder, WekaAlgorithmWrapper wrapper, Properties GOEProps) throws Exception {
        Class wrappedAlgoClass = wrapper.getWrappedAlgorithmClass();
        String implList = GOEProps.getProperty(wrappedAlgoClass.getCanonicalName());
        String hppRoot = wrappedAlgoClass.getCanonicalName();
        hppRoot = hppRoot.substring(0, hppRoot.lastIndexOf(46));
        if (implList == null) {
            throw new WekaException("Unable to get a list of weka implementations for class '" + wrappedAlgoClass.getCanonicalName() + "'");
        }
        Hashtable<String, String> roots = GenericObjectEditor.sortClassesByRoot(implList);
        for (Map.Entry<String, String> e : roots.entrySet()) {
            String classes = e.getValue();
            HierarchyPropertyParser hpp = new HierarchyPropertyParser();
            hpp.build(classes, ", ");
            hpp.goTo(hppRoot);
            this.processPackage(hpp, targetFolder, wrapper);
        }
    }

    protected void processPackage(HierarchyPropertyParser hpp, DefaultMutableTreeNode parentFolder, WekaAlgorithmWrapper wrapper) throws Exception {
        String[] primaryPackages;
        for (String primaryPackage : primaryPackages = hpp.childrenValues()) {
            hpp.goToChild(primaryPackage);
            if (hpp.isLeafReached()) {
                String algName = hpp.fullValue();
                Object wrappedA = Beans.instantiate(this.getClass().getClassLoader(), algName);
                if (wrappedA.getClass().getAnnotation(StepTreeIgnore.class) == null && wrappedA.getClass().getAnnotation(KFIgnore.class) == null) {
                    WekaAlgorithmWrapper wrapperCopy = (WekaAlgorithmWrapper)Beans.instantiate(this.getClass().getClassLoader(), wrapper.getClass().getCanonicalName());
                    wrapperCopy.setWrappedAlgorithm(wrappedA);
                    StepTreeLeafDetails leafData = new StepTreeLeafDetails(wrapperCopy);
                    InvisibleNode wrapperLeafNode = new InvisibleNode(leafData);
                    parentFolder.add(wrapperLeafNode);
                    String tipText = leafData.getToolTipText() != null ? leafData.getToolTipText() : "";
                    this.m_nodeTextIndex.put(algName.toLowerCase() + " " + tipText, wrapperLeafNode);
                }
                hpp.goToParent();
                continue;
            }
            InvisibleNode firstLevelOfMainAlgoType = new InvisibleNode(primaryPackage);
            parentFolder.add(firstLevelOfMainAlgoType);
            this.processPackage(hpp, firstLevelOfMainAlgoType, wrapper);
            hpp.goToParent();
        }
    }

    protected DefaultMutableTreeNode getCategoryFolder(DefaultMutableTreeNode jtreeRoot, String category) {
        DefaultMutableTreeNode targetFolder = null;
        Enumeration<TreeNode> children = jtreeRoot.children();
        while (children.hasMoreElements()) {
            TreeNode child = children.nextElement();
            if (!(child instanceof DefaultMutableTreeNode) || !((DefaultMutableTreeNode)child).getUserObject().toString().equals(category)) continue;
            targetFolder = (DefaultMutableTreeNode)child;
            break;
        }
        if (targetFolder == null) {
            targetFolder = new InvisibleNode(category);
            jtreeRoot.add(targetFolder);
        }
        return targetFolder;
    }

    protected String getStepCategory(Step toAdd) {
        String category = "Plugin";
        KFStep a = toAdd.getClass().getAnnotation(KFStep.class);
        if (a != null) {
            category = a.category();
        }
        return category;
    }

    protected Properties initGOEProps() throws Exception {
        Properties GOEProps = GenericPropertiesCreator.getGlobalOutputProperties();
        if (GOEProps == null) {
            GenericPropertiesCreator creator = new GenericPropertiesCreator();
            if (creator.useDynamic()) {
                creator.execute(false);
                GOEProps = creator.getOutputProperties();
            } else {
                GOEProps = Utils.readProperties("weka/gui/GenericObjectEditor.props");
            }
        }
        return GOEProps;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        DefaultMutableTreeNode node;
        if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
            return null;
        }
        TreePath currPath = this.getPathForLocation(e.getX(), e.getY());
        if (currPath.getLastPathComponent() instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)currPath.getLastPathComponent()).isLeaf()) {
            StepTreeLeafDetails leaf = (StepTreeLeafDetails)node.getUserObject();
            return leaf.getToolTipText();
        }
        return null;
    }

    public void setShowLeafTipText(boolean show) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.isLeaf()) continue;
            ((StepTreeLeafDetails)node.getUserObject()).setShowTipTexts(show);
        }
    }

    protected Map<String, DefaultMutableTreeNode> getNodeTextIndex() {
        return this.m_nodeTextIndex;
    }

    protected static class StepIconRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -4488876734500244945L;

        protected StepIconRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Icon i;
            Object userO;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && (userO = ((DefaultMutableTreeNode)value).getUserObject()) instanceof StepTreeLeafDetails && (i = ((StepTreeLeafDetails)userO).getIcon()) != null) {
                this.setIcon(i);
            }
            return this;
        }
    }
}

