/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.lang.reflect.Method;

public class EnumHelper {
    protected String m_enumClass;
    protected String m_selectedEnumValue;

    public EnumHelper(Enum e) {
        this.m_selectedEnumValue = e.toString();
        this.m_enumClass = e.getClass().getName();
    }

    public EnumHelper() {
    }

    public void setEnumClass(String enumClass) {
        this.m_enumClass = enumClass;
    }

    public String getEnumClass() {
        return this.m_enumClass;
    }

    public void setSelectedEnumValue(String selectedEnumValue) {
        this.m_selectedEnumValue = selectedEnumValue;
    }

    public String getSelectedEnumValue() {
        return this.m_selectedEnumValue;
    }

    public static Object valueFromString(String enmumClass, String enumValue) throws Exception {
        Enum[] values;
        Class<?> eClazz = Class.forName(enmumClass);
        Method valuesM = eClazz.getMethod("values", new Class[0]);
        for (Enum e : values = (Enum[])valuesM.invoke(null, new Object[0])) {
            if (!e.toString().equals(enumValue)) continue;
            return e;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.err.println("usage: weka.core.EnumHelper <enum class> <enum value>");
            }
            Object eVal = EnumHelper.valueFromString(args[0], args[1]);
            System.out.println("The enum's value is: " + eVal.toString());
            System.out.println("The enum's class is: " + eVal.getClass().toString());
            if (eVal instanceof Enum) {
                System.out.println("The value is an instance of Enum superclass");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

