/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Range;
import weka.core.Utils;
import weka.datagenerators.DataGenerator;

public abstract class ClusterGenerator
extends DataGenerator {
    private static final long serialVersionUID = 6131722618472046365L;
    protected int m_NumAttributes;
    protected boolean m_ClassFlag = false;
    protected Range m_booleanCols;
    protected Range m_nominalCols;

    public ClusterGenerator() {
        this.setNumAttributes(this.defaultNumAttributes());
    }

    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        result.addElement(new Option("\tClass Flag, if set, the cluster is listed in extra attribute.", "c", 0, "-c"));
        result.addElement(new Option("\tThe indices for boolean attributes.", "b", 1, "-b <range>"));
        result.addElement(new Option("\tThe indices for nominal attributes.", "m", 1, "-m <range>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('a', options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Integer.parseInt(tmpStr));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        this.setClassFlag(Utils.getFlag('c', options));
        tmpStr = Utils.getOption('b', options);
        this.setBooleanIndices(tmpStr);
        this.m_booleanCols.setUpper(this.getNumAttributes());
        tmpStr = Utils.getOption('m', options);
        this.setNominalIndices(tmpStr);
        this.m_nominalCols.setUpper(this.getNumAttributes());
        tmpStr = this.checkIndices();
        if (tmpStr.length() > 0) {
            throw new IllegalArgumentException(tmpStr);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-a");
        result.add("" + this.getNumAttributes());
        if (this.getClassFlag()) {
            result.add("-c");
        }
        if (!this.getBooleanCols().toString().equalsIgnoreCase("empty")) {
            result.add("-b");
            result.add("" + this.getBooleanCols());
        }
        if (!this.getNominalCols().toString().equalsIgnoreCase("empty")) {
            result.add("-m");
            result.add("" + this.getNominalCols());
        }
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int numAttributes) {
        this.m_NumAttributes = numAttributes;
        this.getBooleanCols().setUpper(this.getNumAttributes());
        this.getNominalCols().setUpper(this.getNumAttributes());
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    public void setClassFlag(boolean classFlag) {
        this.m_ClassFlag = classFlag;
    }

    public boolean getClassFlag() {
        return this.m_ClassFlag;
    }

    public String classFlagTipText() {
        return "If set to TRUE, lists the cluster as an extra attribute.";
    }

    public void setBooleanIndices(String rangeList) {
        this.m_booleanCols.setRanges(rangeList);
    }

    public void setBooleanCols(Range value) {
        this.m_booleanCols.setRanges(value.getRanges());
    }

    public Range getBooleanCols() {
        if (this.m_booleanCols == null) {
            this.m_booleanCols = new Range();
        }
        return this.m_booleanCols;
    }

    public String booleanColsTipText() {
        return "The range of attributes that are generated as boolean ones.";
    }

    public void setNominalIndices(String rangeList) {
        this.m_nominalCols.setRanges(rangeList);
    }

    public void setNominalCols(Range value) {
        this.m_nominalCols.setRanges(value.getRanges());
    }

    public Range getNominalCols() {
        if (this.m_nominalCols == null) {
            this.m_nominalCols = new Range();
        }
        return this.m_nominalCols;
    }

    public String nominalColsTipText() {
        return "The range of attributes to generate as nominal ones.";
    }

    protected String checkIndices() {
        for (int i = 1; i < this.getNumAttributes() + 1; ++i) {
            this.m_booleanCols.isInRange(i);
            if (!this.m_booleanCols.isInRange(i) || !this.m_nominalCols.isInRange(i)) continue;
            return "Error in attribute type: Attribute " + i + " is set boolean and nominal.";
        }
        return "";
    }
}

