/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.ArffSaver;
import weka.core.converters.SerializedInstancesLoader;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Append multiple sets of instances")
public class Appender
extends JPanel
implements BeanCommon,
Visible,
Serializable,
DataSource,
DataSourceListener,
TrainingSetListener,
TestSetListener,
InstanceListener,
EventConstraints {
    private static final long serialVersionUID = 9177433051794199463L;
    protected transient Logger m_log;
    protected Set<String> m_listeneeTypes = new HashSet<String>();
    protected Map<Object, Object> m_listenees = new HashMap<Object, Object>();
    protected transient Map<Object, Instances> m_completed;
    protected transient Map<Object, File> m_tempBatchFiles;
    protected transient Instances m_completeHeader;
    protected transient Map<Object, ArffSaver> m_incrementalSavers;
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected int m_finishedCount;
    protected transient int m_incrementalCounter;
    protected boolean m_busy;
    protected BeanVisual m_visual = new BeanVisual("Appender", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
    protected ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();

    public Appender() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public boolean eventGeneratable(String eventName) {
        if (!this.m_listeneeTypes.contains(eventName)) {
            return false;
        }
        for (Object listenee : this.m_listenees.values()) {
            if (!(listenee instanceof EventConstraints) || ((EventConstraints)listenee).eventGeneratable(eventName)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (this.m_completed == null) {
            this.m_completed = new HashMap<Object, Instances>();
            this.m_incrementalSavers = new HashMap<Object, ArffSaver>();
            this.m_finishedCount = 0;
            this.m_incrementalCounter = 0;
        }
        if (e.getStatus() == 0) {
            if (this.m_completed.containsKey(e.getSource())) {
                if (this.m_log != null) {
                    msg = this.statusMessagePrefix() + "Resetting appender.";
                    this.m_log.statusMessage(msg);
                    this.m_log.logMessage("[Appender] " + msg + " New start of stream detected before " + "all incoming streams have finished!");
                }
                this.m_completed = new HashMap<Object, Instances>();
                this.m_incrementalSavers = new HashMap<Object, ArffSaver>();
                this.m_incrementalCounter = 0;
                this.m_completeHeader = null;
                this.m_finishedCount = 0;
            }
            this.m_completed.put(e.getSource(), e.getStructure());
            if (this.m_completed.size() == this.m_listenees.size()) {
                try {
                    if (this.m_log != null) {
                        msg = this.statusMessagePrefix() + "Making output header";
                        this.m_log.statusMessage(msg);
                        this.m_log.logMessage("[Appender] " + msg);
                    }
                    this.m_completeHeader = this.makeOutputHeader();
                    this.m_ie.setStructure(this.m_completeHeader);
                    this.notifyInstanceListeners(this.m_ie);
                    if (this.m_incrementalSavers.size() > 0) {
                        for (ArffSaver s : this.m_incrementalSavers.values()) {
                            s.writeIncremental(null);
                            tmpFile = s.retrieveFile();
                            loader = new ArffLoader();
                            loader.setFile(tmpFile);
                            tempStructure = loader.getStructure();
                            tempLoaded = loader.getNextInstance(tempStructure);
                            while (tempLoaded != null) {
                                converted = this.makeOutputInstance(this.m_completeHeader, tempLoaded);
                                this.m_ie.setStatus(1);
                                this.m_ie.setInstance(converted);
                                this.notifyInstanceListeners(this.m_ie);
                                ++this.m_incrementalCounter;
                                if (this.m_incrementalCounter % 10000 == 0 && this.m_log != null) {
                                    this.m_log.statusMessage(this.statusMessagePrefix() + "Processed " + this.m_incrementalCounter + " instances");
                                }
                                tempLoaded = loader.getNextInstance(tempStructure);
                            }
                        }
                        this.m_incrementalSavers.clear();
                    }
                }
                catch (Exception e1) {
                    msg = this.statusMessagePrefix() + "ERROR: unable to create output instances structure.";
                    if (this.m_log != null) {
                        this.m_log.statusMessage(msg);
                        this.m_log.logMessage("[Appender] " + e1.getMessage());
                    }
                    this.stop();
                    e1.printStackTrace();
                    this.m_busy = false;
                    return;
                }
            }
            this.m_busy = false;
            return;
        }
        if (e.getStatus() == 2 || e.getStatus() == 1) {
            currentI = e.getInstance();
            if (this.m_completeHeader == null) {
                if (currentI != null) {
                    saver = this.m_incrementalSavers.get(e.getSource());
                    if (saver == null) {
                        saver = new ArffSaver();
                        try {
                            tmpFile = File.createTempFile("weka", ".arff");
                            saver.setFile(tmpFile);
                            saver.setRetrieval(2);
                            saver.setInstances(new Instances(currentI.dataset(), 0));
                            this.m_incrementalSavers.put(e.getSource(), saver);
                        }
                        catch (IOException e1) {
                            this.stop();
                            e1.printStackTrace();
                            msg = this.statusMessagePrefix() + "ERROR: unable to save instance to temp file";
                            if (this.m_log != null) {
                                this.m_log.statusMessage(msg);
                                this.m_log.logMessage("[Appender] " + e1.getMessage());
                            }
                            this.m_busy = false;
                            return;
                        }
                    }
                    try {
                        saver.writeIncremental(currentI);
                        if (e.getStatus() != 2) ** GOTO lbl121
                        ++this.m_finishedCount;
                    }
                    catch (IOException e1) {
                        this.stop();
                        e1.printStackTrace();
                        msg = this.statusMessagePrefix() + "ERROR: unable to save instance to temp file";
                        if (this.m_log != null) {
                            this.m_log.statusMessage(msg);
                            this.m_log.logMessage("[Appender] " + e1.getMessage());
                        }
                        this.m_busy = false;
                        return;
                    }
                }
            } else if (currentI != null) {
                code = 1;
                if (e.getStatus() == 2) {
                    ++this.m_finishedCount;
                    if (this.m_finishedCount == this.m_listenees.size()) {
                        code = 2;
                    }
                }
                newI = this.makeOutputInstance(this.m_completeHeader, currentI);
                this.m_ie.setStatus(code);
                this.m_ie.setInstance(newI);
                this.notifyInstanceListeners(this.m_ie);
                ++this.m_incrementalCounter;
                if (this.m_incrementalCounter % 10000 == 0 && this.m_log != null) {
                    this.m_log.statusMessage(this.statusMessagePrefix() + "Processed " + this.m_incrementalCounter + " instances");
                }
                if (code == 2) {
                    if (this.m_log != null) {
                        this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
                    }
                    this.m_completed = null;
                    this.m_incrementalSavers = null;
                    this.m_incrementalCounter = 0;
                    this.m_completeHeader = null;
                    this.m_finishedCount = 0;
                }
            }
        }
lbl121:
        // 10 sources

        this.m_busy = false;
    }

    public void acceptTestSet(TestSetEvent e) {
        DataSetEvent de = new DataSetEvent(e.getSource(), e.getTestSet());
        this.acceptDataSet(de);
    }

    public void acceptTrainingSet(TrainingSetEvent e) {
        DataSetEvent de = new DataSetEvent(e.getSource(), e.getTrainingSet());
        this.acceptDataSet(de);
    }

    public synchronized void acceptDataSet(DataSetEvent e) {
        Object source;
        this.m_busy = true;
        if (this.m_completed == null) {
            this.m_completed = new HashMap<Object, Instances>();
            this.m_tempBatchFiles = new HashMap<Object, File>();
        }
        if (this.m_completed.containsKey(source = e.getSource())) {
            if (this.m_log != null && !e.isStructureOnly()) {
                String msg = this.statusMessagePrefix() + "Resetting appender.";
                this.m_log.statusMessage(msg);
                this.m_log.logMessage("[Appender] " + msg + " New batch for an incoming connection " + "detected before " + "all incoming connections have sent data!");
            }
            this.m_completed = new HashMap<Object, Instances>();
            this.m_tempBatchFiles = new HashMap<Object, File>();
        }
        Instances header = new Instances(e.getDataSet(), 0);
        this.m_completed.put(source, header);
        try {
            File tmpF = File.createTempFile("weka", SerializedInstancesLoader.FILE_EXTENSION);
            tmpF.deleteOnExit();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tmpF)));
            oos.writeObject(e.getDataSet());
            oos.flush();
            oos.close();
            this.m_tempBatchFiles.put(source, tmpF);
        }
        catch (IOException e1) {
            this.stop();
            e1.printStackTrace();
            String msg = this.statusMessagePrefix() + "ERROR: unable to save batch instances to temp file";
            if (this.m_log != null) {
                this.m_log.statusMessage(msg);
                this.m_log.logMessage("[Appender] " + e1.getMessage());
            }
            this.m_busy = false;
            return;
        }
        if (this.m_completed.size() == this.m_listenees.size()) {
            block13: {
                String msg;
                try {
                    Instances output = this.makeOutputHeader();
                    if (this.m_log != null) {
                        msg = this.statusMessagePrefix() + "Making output header";
                        this.m_log.statusMessage(msg);
                        this.m_log.logMessage("[Appender] " + msg);
                    }
                    for (File f : this.m_tempBatchFiles.values()) {
                        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)));
                        Instances temp = (Instances)ois.readObject();
                        ois.close();
                        for (int i = 0; i < temp.numInstances(); ++i) {
                            Instance converted = this.makeOutputInstance(output, temp.instance(i));
                            output.add(converted);
                        }
                    }
                    DataSetEvent d = new DataSetEvent(this, output);
                    this.notifyDataListeners(d);
                }
                catch (Exception ex) {
                    this.stop();
                    ex.printStackTrace();
                    msg = this.statusMessagePrefix() + "ERROR: unable to output appended data set";
                    if (this.m_log == null) break block13;
                    this.m_log.statusMessage(msg);
                    this.m_log.logMessage("[Appender] " + ex.getMessage());
                }
            }
            this.m_completed = null;
            this.m_tempBatchFiles = null;
            if (this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
            }
        }
        this.m_busy = false;
    }

    private Instance makeOutputInstance(Instances output, Instance source) {
        int i;
        double[] newVals = new double[output.numAttributes()];
        for (i = 0; i < newVals.length; ++i) {
            newVals[i] = Utils.missingValue();
        }
        for (i = 0; i < source.numAttributes(); ++i) {
            if (source.isMissing(i)) continue;
            Attribute s = source.attribute(i);
            int outputIndex = output.attribute(s.name()).index();
            if (s.isNumeric()) {
                newVals[outputIndex] = source.value(s);
                continue;
            }
            if (s.isString()) {
                String sVal = source.stringValue(s);
                newVals[outputIndex] = output.attribute(outputIndex).addStringValue(sVal);
                continue;
            }
            if (s.isRelationValued()) {
                Instances rVal = source.relationalValue(s);
                newVals[outputIndex] = output.attribute(outputIndex).addRelation(rVal);
                continue;
            }
            if (!s.isNominal()) continue;
            String nomVal = source.stringValue(s);
            newVals[outputIndex] = output.attribute(outputIndex).indexOfValue(nomVal);
        }
        DenseInstance newInst = new DenseInstance(source.weight(), newVals);
        newInst.setDataset(output);
        return newInst;
    }

    private Instances makeOutputHeader() throws Exception {
        HashMap<String, Attribute> attLookup = new HashMap<String, Attribute>();
        ArrayList<Attribute> attList = new ArrayList<Attribute>();
        HashMap nominalLookups = new HashMap();
        for (Instances h : this.m_completed.values()) {
            for (int i = 0; i < h.numAttributes(); ++i) {
                Attribute a = h.attribute(i);
                if (!attLookup.containsKey(a.name())) {
                    attLookup.put(a.name(), a);
                    attList.add(a);
                    if (!a.isNominal()) continue;
                    TreeSet<String> nVals = new TreeSet<String>();
                    for (int j = 0; j < a.numValues(); ++j) {
                        nVals.add(a.value(j));
                    }
                    nominalLookups.put(a.name(), nVals);
                    continue;
                }
                Attribute storedVersion = (Attribute)attLookup.get(a.name());
                if (storedVersion.type() != a.type()) {
                    throw new Exception("Conflicting types for attribute name '" + a.name() + "' between incoming " + "instance sets");
                }
                if (!storedVersion.isNominal()) continue;
                Set storedVals = (Set)nominalLookups.get(a.name());
                for (int j = 0; j < a.numValues(); ++j) {
                    storedVals.add(a.value(j));
                }
            }
        }
        ArrayList<Attribute> finalAttList = new ArrayList<Attribute>();
        for (Attribute a : attList) {
            Attribute newAtt = null;
            if (a.isDate()) {
                newAtt = new Attribute(a.name(), a.getDateFormat());
            } else if (a.isNumeric()) {
                newAtt = new Attribute(a.name());
            } else if (a.isRelationValued()) {
                newAtt = new Attribute(a.name(), a.relation());
            } else if (a.isNominal()) {
                Set vals = (Set)nominalLookups.get(a.name());
                ArrayList<String> newVals = new ArrayList<String>();
                for (String v : vals) {
                    newVals.add(v);
                }
                newAtt = new Attribute(a.name(), newVals);
            } else if (a.isString()) {
                newAtt = new Attribute(a.name(), (List<String>)null);
            }
            finalAttList.add(newAtt);
        }
        Instances outputHeader = new Instances("Appended_" + this.m_listenees.size() + "_sets", finalAttList, 0);
        return outputHeader;
    }

    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.add(dsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    public synchronized void addInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.add(tsl);
    }

    public synchronized void removeInstanceListener(InstanceListener tsl) {
        this.m_instanceListeners.remove(tsl);
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
        this.m_visual.setText("Appender");
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void stop() {
        if (this.m_listenees != null && this.m_listenees.size() > 0) {
            for (Object l : this.m_listenees.values()) {
                if (!(l instanceof BeanCommon)) continue;
                ((BeanCommon)l).stop();
            }
        }
        this.m_busy = false;
    }

    public boolean isBusy() {
        return this.m_busy;
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    public boolean connectionAllowed(String eventName) {
        if (!(eventName.equals("dataSet") || eventName.equals("trainingSet") || eventName.equals("testSet") || eventName.equals("instance"))) {
            return false;
        }
        if (this.m_listeneeTypes.size() == 0) {
            return true;
        }
        if (this.m_listeneeTypes.contains("instance") && !eventName.equals("instance")) {
            return false;
        }
        return this.m_listeneeTypes.contains("instance") || !eventName.equals("instance");
    }

    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listeneeTypes.add(eventName);
            this.m_listenees.put(source, source);
        }
    }

    public void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(source);
        if (this.m_listenees.size() == 0) {
            this.m_listeneeTypes.clear();
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        Appender appender = this;
        synchronized (appender) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataListeners(DataSetEvent e) {
        List l;
        Appender appender = this;
        synchronized (appender) {
            l = (List)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (DataSourceListener ds : l) {
                ds.acceptDataSet(e);
            }
        }
    }
}

