/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.util.Random;
import weka.core.Statistics;
import weka.estimators.UnivariateDensityEstimator;
import weka.estimators.UnivariateIntervalEstimator;
import weka.estimators.UnivariateQuantileEstimator;

public class UnivariateNormalEstimator
implements UnivariateDensityEstimator,
UnivariateIntervalEstimator,
UnivariateQuantileEstimator {
    protected double m_WeightedSum = 0.0;
    protected double m_WeightedSumSquared = 0.0;
    protected double m_SumOfWeights = 0.0;
    protected double m_Mean = 0.0;
    protected double m_Variance = Double.MAX_VALUE;
    protected double m_MinVar = 1.0E-12;
    public static final double CONST = Math.log(Math.PI * 2);

    public void addValue(double value, double weight) {
        this.m_WeightedSum += value * weight;
        this.m_WeightedSumSquared += value * value * weight;
        this.m_SumOfWeights += weight;
    }

    protected void updateMeanAndVariance() {
        this.m_Mean = 0.0;
        if (this.m_SumOfWeights > 0.0) {
            this.m_Mean = this.m_WeightedSum / this.m_SumOfWeights;
        }
        this.m_Variance = Double.MAX_VALUE;
        if (this.m_SumOfWeights > 0.0) {
            this.m_Variance = this.m_WeightedSumSquared / this.m_SumOfWeights - this.m_Mean * this.m_Mean;
        }
        if (this.m_Variance <= this.m_MinVar) {
            this.m_Variance = this.m_MinVar;
        }
    }

    public double[][] predictIntervals(double conf) {
        this.updateMeanAndVariance();
        double val = Statistics.normalInverse(1.0 - (1.0 - conf) / 2.0);
        double[][] arr = new double[1][2];
        arr[0][1] = this.m_Mean + val * Math.sqrt(this.m_Variance);
        arr[0][0] = this.m_Mean - val * Math.sqrt(this.m_Variance);
        return arr;
    }

    public double predictQuantile(double percentage) {
        this.updateMeanAndVariance();
        return this.m_Mean + Statistics.normalInverse(percentage) * Math.sqrt(this.m_Variance);
    }

    public double logDensity(double value) {
        this.updateMeanAndVariance();
        double val = -0.5 * (CONST + Math.log(this.m_Variance) + (value - this.m_Mean) * (value - this.m_Mean) / this.m_Variance);
        return val;
    }

    public String toString() {
        this.updateMeanAndVariance();
        return "Mean: " + this.m_Mean + "\t" + "Variance: " + this.m_Variance;
    }

    public static void main(String[] args) {
        double val;
        int i;
        int i2;
        Random r = new Random();
        UnivariateNormalEstimator e = new UnivariateNormalEstimator();
        System.out.println(e);
        double sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian(), 1.0);
            e.addValue(r.nextGaussian() * 2.0, 3.0);
        }
        System.out.println(e);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e = new UnivariateNormalEstimator();
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian(), 1.0);
            e.addValue(r.nextGaussian() * 2.0, 1.0);
            e.addValue(r.nextGaussian() * 2.0, 1.0);
            e.addValue(r.nextGaussian() * 2.0, 1.0);
        }
        System.out.println(e);
        sum = 0.0;
        for (i2 = 0; i2 < 100000; ++i2) {
            sum += Math.exp(e.logDensity(r.nextDouble() * 10.0 - 5.0));
        }
        System.out.println("Approximate integral: " + 10.0 * sum / 100000.0);
        e = new UnivariateNormalEstimator();
        for (i2 = 0; i2 < 100000; ++i2) {
            e.addValue(r.nextGaussian() * 5.0 + 3.0, 1.0);
        }
        System.out.println(e);
        double[][] intervals = e.predictIntervals(0.95);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        double covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
        intervals = e.predictIntervals(0.8);
        System.out.println("Lower: " + intervals[0][0] + " Upper: " + intervals[0][1]);
        covered = 0.0;
        for (i = 0; i < 100000; ++i) {
            val = r.nextGaussian() * 5.0 + 3.0;
            if (!(val >= intervals[0][0]) || !(val <= intervals[0][1])) continue;
            covered += 1.0;
        }
        System.out.println("Coverage: " + covered / 100000.0);
    }
}

