/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class ReliefFAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -8422186665795839379L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private boolean m_numericClass;
    private int m_numClasses;
    private double m_ndc;
    private double[] m_nda;
    private double[] m_ndcda;
    private double[] m_weights;
    private double[] m_classProbs;
    private int m_sampleM;
    private int m_Knn;
    private double[][][] m_karray;
    private double[] m_maxArray;
    private double[] m_minArray;
    private double[] m_worst;
    private int[] m_index;
    private int[] m_stored;
    private int m_seed;
    private double[] m_weightsByRank;
    private int m_sigma;
    private boolean m_weightByDistance;

    public ReliefFAttributeEval() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "ReliefFAttributeEval :\n\nEvaluates the worth of an attribute by repeatedly sampling an instance and considering the value of the given attribute for the nearest instance of the same and different class. Can operate on both discrete and continuous class data.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Kenji Kira and Larry A. Rendell");
        result.setValue(TechnicalInformation.Field.TITLE, "A Practical Approach to Feature Selection");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Ninth International Workshop on Machine Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "Derek H. Sleeman and Peter Edwards");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.PAGES, "249-256");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Igor Kononenko");
        additional.setValue(TechnicalInformation.Field.TITLE, "Estimating Attributes: Analysis and Extensions of RELIEF");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "European Conference on Machine Learning");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Francesco Bergadano and Luc De Raedt");
        additional.setValue(TechnicalInformation.Field.YEAR, "1994");
        additional.setValue(TechnicalInformation.Field.PAGES, "171-182");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Marko Robnik-Sikonja and Igor Kononenko");
        additional.setValue(TechnicalInformation.Field.TITLE, "An adaptation of Relief for attribute estimation in regression");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourteenth International Conference on Machine Learning");
        additional.setValue(TechnicalInformation.Field.EDITOR, "Douglas H. Fisher");
        additional.setValue(TechnicalInformation.Field.YEAR, "1997");
        additional.setValue(TechnicalInformation.Field.PAGES, "296-304");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSpecify the number of instances to\n\tsample when estimating attributes.\n\tIf not specified, then all instances\n\twill be used.", "M", 1, "-M <num instances>"));
        newVector.addElement(new Option("\tSeed for randomly sampling instances.\n\t(Default = 1)", "D", 1, "-D <seed>"));
        newVector.addElement(new Option("\tNumber of nearest neighbours (k) used\n\tto estimate attribute relevances\n\t(Default = 10).", "K", 1, "-K <number of neighbours>"));
        newVector.addElement(new Option("\tWeight nearest neighbours by distance", "W", 0, "-W"));
        newVector.addElement(new Option("\tSpecify sigma value (used in an exp\n\tfunction to control how quickly\n\tweights for more distant instances\n\tdecrease. Use in conjunction with -W.\n\tSensible value=1/5 to 1/10 of the\n\tnumber of nearest neighbours.\n\t(Default = 2)", "A", 1, "-A <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setWeightByDistance(Utils.getFlag('W', options));
        String optionString = Utils.getOption('M', options);
        if (optionString.length() != 0) {
            this.setSampleSize(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('D', options)).length() != 0) {
            this.setSeed(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('K', options)).length() != 0) {
            this.setNumNeighbours(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('A', options)).length() != 0) {
            this.setWeightByDistance(true);
            this.setSigma(Integer.parseInt(optionString));
        }
    }

    public String sigmaTipText() {
        return "Set influence of nearest neighbours. Used in an exp function to control how quickly weights decrease for more distant instances. Use in conjunction with weightByDistance. Sensible values = 1/5 to 1/10 the number of nearest neighbours.";
    }

    public void setSigma(int s) throws Exception {
        if (s <= 0) {
            throw new Exception("value of sigma must be > 0!");
        }
        this.m_sigma = s;
    }

    public int getSigma() {
        return this.m_sigma;
    }

    public String numNeighboursTipText() {
        return "Number of nearest neighbours for attribute estimation.";
    }

    public void setNumNeighbours(int n) {
        this.m_Knn = n;
    }

    public int getNumNeighbours() {
        return this.m_Knn;
    }

    public String seedTipText() {
        return "Random seed for sampling instances.";
    }

    public void setSeed(int s) {
        this.m_seed = s;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String sampleSizeTipText() {
        return "Number of instances to sample. Default (-1) indicates that all instances will be used for attribute estimation.";
    }

    public void setSampleSize(int s) {
        this.m_sampleM = s;
    }

    public int getSampleSize() {
        return this.m_sampleM;
    }

    public String weightByDistanceTipText() {
        return "Weight nearest neighbours by their distance.";
    }

    public void setWeightByDistance(boolean b) {
        this.m_weightByDistance = b;
    }

    public boolean getWeightByDistance() {
        return this.m_weightByDistance;
    }

    public String[] getOptions() {
        String[] options = new String[9];
        int current = 0;
        if (this.getWeightByDistance()) {
            options[current++] = "-W";
        }
        options[current++] = "-M";
        options[current++] = "" + this.getSampleSize();
        options[current++] = "-D";
        options[current++] = "" + this.getSeed();
        options[current++] = "-K";
        options[current++] = "" + this.getNumNeighbours();
        if (this.getWeightByDistance()) {
            options[current++] = "-A";
            options[current++] = "" + this.getSigma();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("ReliefF feature evaluator has not been built yet\n");
        } else {
            text.append("\tReliefF Ranking Filter");
            text.append("\n\tInstances sampled: ");
            if (this.m_sampleM == -1) {
                text.append("all\n");
            } else {
                text.append(this.m_sampleM + "\n");
            }
            text.append("\tNumber of nearest neighbours (k): " + this.m_Knn + "\n");
            if (this.m_weightByDistance) {
                text.append("\tExponentially decreasing (with distance) influence for\n\tnearest neighbours. Sigma: " + this.m_sigma + "\n");
            } else {
                text.append("\tEqual influence nearest neighbours\n");
            }
        }
        return text.toString();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildEvaluator(Instances data) throws Exception {
        int i;
        Random r = new Random(this.m_seed);
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = data;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numericClass = this.m_trainInstances.attribute(this.m_classIndex).isNumeric();
        if (!this.m_numericClass) {
            this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
        } else {
            this.m_ndc = 0.0;
            this.m_numClasses = 1;
            this.m_nda = new double[this.m_numAttribs];
            this.m_ndcda = new double[this.m_numAttribs];
        }
        if (this.m_weightByDistance) {
            this.m_weightsByRank = new double[this.m_Knn];
            for (i = 0; i < this.m_Knn; ++i) {
                this.m_weightsByRank[i] = Math.exp(-((double)i / (double)this.m_sigma * ((double)i / (double)this.m_sigma)));
            }
        }
        this.m_weights = new double[this.m_numAttribs];
        this.m_karray = new double[this.m_numClasses][this.m_Knn][2];
        if (!this.m_numericClass) {
            this.m_classProbs = new double[this.m_numClasses];
            for (i = 0; i < this.m_numInstances; ++i) {
                int n = (int)this.m_trainInstances.instance(i).value(this.m_classIndex);
                this.m_classProbs[n] = this.m_classProbs[n] + 1.0;
            }
            i = 0;
            while (i < this.m_numClasses) {
                int n = i++;
                this.m_classProbs[n] = this.m_classProbs[n] / (double)this.m_numInstances;
            }
        }
        this.m_worst = new double[this.m_numClasses];
        this.m_index = new int[this.m_numClasses];
        this.m_stored = new int[this.m_numClasses];
        this.m_minArray = new double[this.m_numAttribs];
        this.m_maxArray = new double[this.m_numAttribs];
        for (i = 0; i < this.m_numAttribs; ++i) {
            this.m_maxArray[i] = Double.NaN;
            this.m_minArray[i] = Double.NaN;
        }
        for (i = 0; i < this.m_numInstances; ++i) {
            this.updateMinMax(this.m_trainInstances.instance(i));
        }
        int totalInstances = this.m_sampleM > this.m_numInstances || this.m_sampleM < 0 ? this.m_numInstances : this.m_sampleM;
        for (i = 0; i < totalInstances; ++i) {
            int z = totalInstances == this.m_numInstances ? i : r.nextInt() % this.m_numInstances;
            if (z < 0) {
                z *= -1;
            }
            if (this.m_trainInstances.instance(z).isMissing(this.m_classIndex)) continue;
            for (int j = 0; j < this.m_numClasses; ++j) {
                this.m_stored[j] = 0;
                this.m_index[j] = 0;
                for (int k = 0; k < this.m_Knn; ++k) {
                    this.m_karray[j][k][1] = 0.0;
                    this.m_karray[j][k][0] = 0.0;
                }
            }
            this.findKHitMiss(z);
            if (this.m_numericClass) {
                this.updateWeightsNumericClass(z);
                continue;
            }
            this.updateWeightsDiscreteClass(z);
        }
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (i == this.m_classIndex) continue;
            if (this.m_numericClass) {
                this.m_weights[i] = this.m_ndcda[i] / this.m_ndc - (this.m_nda[i] - this.m_ndcda[i]) / ((double)totalInstances - this.m_ndc);
                continue;
            }
            int n = i;
            this.m_weights[n] = this.m_weights[n] * (1.0 / (double)totalInstances);
        }
    }

    public double evaluateAttribute(int attribute) throws Exception {
        return this.m_weights[attribute];
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_sampleM = -1;
        this.m_Knn = 10;
        this.m_sigma = 2;
        this.m_weightByDistance = false;
        this.m_seed = 1;
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.m_minArray[i]) || Utils.eq(this.m_maxArray[i], this.m_minArray[i])) {
            return 0.0;
        }
        return (x - this.m_minArray[i]) / (this.m_maxArray[i] - this.m_minArray[i]);
    }

    private void updateMinMax(Instance instance) {
        try {
            for (int j = 0; j < instance.numValues(); ++j) {
                if (!instance.attributeSparse(j).isNumeric() || instance.isMissingSparse(j)) continue;
                if (Double.isNaN(this.m_minArray[instance.index(j)])) {
                    this.m_minArray[instance.index((int)j)] = instance.valueSparse(j);
                    this.m_maxArray[instance.index((int)j)] = instance.valueSparse(j);
                    continue;
                }
                if (instance.valueSparse(j) < this.m_minArray[instance.index(j)]) {
                    this.m_minArray[instance.index((int)j)] = instance.valueSparse(j);
                    continue;
                }
                if (!(instance.valueSparse(j) > this.m_maxArray[instance.index(j)])) continue;
                this.m_maxArray[instance.index((int)j)] = instance.valueSparse(j);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            ex.printStackTrace();
        }
    }

    private double difference(int index, double val1, double val2) {
        switch (this.m_trainInstances.attribute(index).type()) {
            case 1: {
                if (Utils.isMissingValue(val1) || Utils.isMissingValue(val2)) {
                    return 1.0 - 1.0 / (double)this.m_trainInstances.attribute(index).numValues();
                }
                if ((int)val1 != (int)val2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Utils.isMissingValue(val1) || Utils.isMissingValue(val2)) {
                    if (Utils.isMissingValue(val1) && Utils.isMissingValue(val2)) {
                        return 1.0;
                    }
                    double diff = Utils.isMissingValue(val2) ? this.norm(val1, index) : this.norm(val2, index);
                    if (diff < 0.5) {
                        diff = 1.0 - diff;
                    }
                    return diff;
                }
                return Math.abs(this.norm(val1, index) - this.norm(val2, index));
            }
        }
        return 0.0;
    }

    private double distance(Instance first, Instance second) {
        double distance = 0.0;
        int p1 = 0;
        int p2 = 0;
        while (p1 < first.numValues() || p2 < second.numValues()) {
            double diff;
            int firstI = p1 >= first.numValues() ? this.m_trainInstances.numAttributes() : first.index(p1);
            int secondI = p2 >= second.numValues() ? this.m_trainInstances.numAttributes() : second.index(p2);
            if (firstI == this.m_trainInstances.classIndex()) {
                ++p1;
                continue;
            }
            if (secondI == this.m_trainInstances.classIndex()) {
                ++p2;
                continue;
            }
            if (firstI == secondI) {
                diff = this.difference(firstI, first.valueSparse(p1), second.valueSparse(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                diff = this.difference(secondI, 0.0, second.valueSparse(p2));
                ++p2;
            } else {
                diff = this.difference(firstI, first.valueSparse(p1), 0.0);
                ++p1;
            }
            distance += diff;
        }
        return distance;
    }

    private void updateWeightsNumericClass(int instNum) {
        int j;
        int[] tempSorted = null;
        double[] tempDist = null;
        double distNorm = 1.0;
        Instance inst = this.m_trainInstances.instance(instNum);
        if (this.m_weightByDistance) {
            tempDist = new double[this.m_stored[0]];
            distNorm = 0.0;
            for (j = 0; j < this.m_stored[0]; ++j) {
                tempDist[j] = this.m_karray[0][j][0];
                distNorm += this.m_weightsByRank[j];
            }
            tempSorted = Utils.sort(tempDist);
        }
        for (int i = 0; i < this.m_stored[0]; ++i) {
            double temp;
            if (this.m_weightByDistance) {
                temp = this.difference(this.m_classIndex, inst.value(this.m_classIndex), this.m_trainInstances.instance((int)this.m_karray[0][tempSorted[i]][1]).value(this.m_classIndex));
                temp *= this.m_weightsByRank[i] / distNorm;
            } else {
                temp = this.difference(this.m_classIndex, inst.value(this.m_classIndex), this.m_trainInstances.instance((int)this.m_karray[0][i][1]).value(this.m_classIndex));
                temp *= 1.0 / (double)this.m_stored[0];
            }
            this.m_ndc += temp;
            Instance cmp = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[0][tempSorted[i]][1]) : this.m_trainInstances.instance((int)this.m_karray[0][i][1]);
            double temp_diffP_diffA_givNearest = this.difference(this.m_classIndex, inst.value(this.m_classIndex), cmp.value(this.m_classIndex));
            int p1 = 0;
            int p2 = 0;
            while (p1 < inst.numValues() || p2 < cmp.numValues()) {
                int firstI = p1 >= inst.numValues() ? this.m_trainInstances.numAttributes() : inst.index(p1);
                int secondI = p2 >= cmp.numValues() ? this.m_trainInstances.numAttributes() : cmp.index(p2);
                if (firstI == this.m_trainInstances.classIndex()) {
                    ++p1;
                    continue;
                }
                if (secondI == this.m_trainInstances.classIndex()) {
                    ++p2;
                    continue;
                }
                temp = 0.0;
                double temp2 = 0.0;
                if (firstI == secondI) {
                    j = firstI;
                    temp = this.difference(j, inst.valueSparse(p1), cmp.valueSparse(p2));
                    ++p1;
                    ++p2;
                } else if (firstI > secondI) {
                    j = secondI;
                    temp = this.difference(j, 0.0, cmp.valueSparse(p2));
                    ++p2;
                } else {
                    j = firstI;
                    temp = this.difference(j, inst.valueSparse(p1), 0.0);
                    ++p1;
                }
                temp2 = temp_diffP_diffA_givNearest * temp;
                temp2 = this.m_weightByDistance ? (temp2 *= this.m_weightsByRank[i] / distNorm) : (temp2 *= 1.0 / (double)this.m_stored[0]);
                int n = j;
                this.m_ndcda[n] = this.m_ndcda[n] + temp2;
                temp = this.m_weightByDistance ? (temp *= this.m_weightsByRank[i] / distNorm) : (temp *= 1.0 / (double)this.m_stored[0]);
                int n2 = j;
                this.m_nda[n2] = this.m_nda[n2] + temp;
            }
        }
    }

    private void updateWeightsDiscreteClass(int instNum) {
        int i;
        int secondI;
        int firstI;
        int p2;
        int p1;
        Instance cmp;
        int k;
        int j;
        double w_norm = 1.0;
        int[] tempSortedClass = null;
        double distNormClass = 1.0;
        int[][] tempSortedAtt = null;
        double[] distNormAtt = null;
        Instance inst = this.m_trainInstances.instance(instNum);
        int cl = (int)this.m_trainInstances.instance(instNum).value(this.m_classIndex);
        if (this.m_weightByDistance) {
            double[] tempDistClass = new double[this.m_stored[cl]];
            distNormClass = 0.0;
            for (j = 0; j < this.m_stored[cl]; ++j) {
                tempDistClass[j] = this.m_karray[cl][j][0];
                distNormClass += this.m_weightsByRank[j];
            }
            tempSortedClass = Utils.sort(tempDistClass);
            tempSortedAtt = new int[this.m_numClasses][1];
            distNormAtt = new double[this.m_numClasses];
            for (k = 0; k < this.m_numClasses; ++k) {
                if (k == cl) continue;
                double[] tempDistAtt = new double[this.m_stored[k]];
                distNormAtt[k] = 0.0;
                for (j = 0; j < this.m_stored[k]; ++j) {
                    tempDistAtt[j] = this.m_karray[k][j][0];
                    int n = k;
                    distNormAtt[n] = distNormAtt[n] + this.m_weightsByRank[j];
                }
                tempSortedAtt[k] = Utils.sort(tempDistAtt);
            }
        }
        if (this.m_numClasses > 2) {
            w_norm = 1.0 - this.m_classProbs[cl];
        }
        double temp_diff = 0.0;
        for (j = 0; j < this.m_stored[cl]; ++j) {
            cmp = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[cl][tempSortedClass[j]][1]) : this.m_trainInstances.instance((int)this.m_karray[cl][j][1]);
            p1 = 0;
            p2 = 0;
            while (p1 < inst.numValues() || p2 < cmp.numValues()) {
                firstI = p1 >= inst.numValues() ? this.m_trainInstances.numAttributes() : inst.index(p1);
                secondI = p2 >= cmp.numValues() ? this.m_trainInstances.numAttributes() : cmp.index(p2);
                if (firstI == this.m_trainInstances.classIndex()) {
                    ++p1;
                    continue;
                }
                if (secondI == this.m_trainInstances.classIndex()) {
                    ++p2;
                    continue;
                }
                if (firstI == secondI) {
                    i = firstI;
                    temp_diff = this.difference(i, inst.valueSparse(p1), cmp.valueSparse(p2));
                    ++p1;
                    ++p2;
                } else if (firstI > secondI) {
                    i = secondI;
                    temp_diff = this.difference(i, 0.0, cmp.valueSparse(p2));
                    ++p2;
                } else {
                    i = firstI;
                    temp_diff = this.difference(i, inst.valueSparse(p1), 0.0);
                    ++p1;
                }
                if (this.m_weightByDistance) {
                    temp_diff *= this.m_weightsByRank[j] / distNormClass;
                } else if (this.m_stored[cl] > 0) {
                    temp_diff /= (double)this.m_stored[cl];
                }
                int n = i;
                this.m_weights[n] = this.m_weights[n] - temp_diff;
            }
        }
        temp_diff = 0.0;
        for (k = 0; k < this.m_numClasses; ++k) {
            if (k == cl) continue;
            for (j = 0; j < this.m_stored[k]; ++j) {
                cmp = this.m_weightByDistance ? this.m_trainInstances.instance((int)this.m_karray[k][tempSortedAtt[k][j]][1]) : this.m_trainInstances.instance((int)this.m_karray[k][j][1]);
                p1 = 0;
                p2 = 0;
                while (p1 < inst.numValues() || p2 < cmp.numValues()) {
                    firstI = p1 >= inst.numValues() ? this.m_trainInstances.numAttributes() : inst.index(p1);
                    secondI = p2 >= cmp.numValues() ? this.m_trainInstances.numAttributes() : cmp.index(p2);
                    if (firstI == this.m_trainInstances.classIndex()) {
                        ++p1;
                        continue;
                    }
                    if (secondI == this.m_trainInstances.classIndex()) {
                        ++p2;
                        continue;
                    }
                    if (firstI == secondI) {
                        i = firstI;
                        temp_diff = this.difference(i, inst.valueSparse(p1), cmp.valueSparse(p2));
                        ++p1;
                        ++p2;
                    } else if (firstI > secondI) {
                        i = secondI;
                        temp_diff = this.difference(i, 0.0, cmp.valueSparse(p2));
                        ++p2;
                    } else {
                        i = firstI;
                        temp_diff = this.difference(i, inst.valueSparse(p1), 0.0);
                        ++p1;
                    }
                    if (this.m_weightByDistance) {
                        temp_diff *= this.m_weightsByRank[j] / distNormAtt[k];
                    } else if (this.m_stored[k] > 0) {
                        temp_diff /= (double)this.m_stored[k];
                    }
                    if (this.m_numClasses > 2) {
                        int n = i;
                        this.m_weights[n] = this.m_weights[n] + this.m_classProbs[k] / w_norm * temp_diff;
                        continue;
                    }
                    int n = i;
                    this.m_weights[n] = this.m_weights[n] + temp_diff;
                }
            }
        }
    }

    private void findKHitMiss(int instNum) {
        double temp_diff = 0.0;
        Instance thisInst = this.m_trainInstances.instance(instNum);
        for (int i = 0; i < this.m_numInstances; ++i) {
            int j;
            double ww;
            if (i == instNum) continue;
            Instance cmpInst = this.m_trainInstances.instance(i);
            temp_diff = this.distance(cmpInst, thisInst);
            int cl = this.m_numericClass ? 0 : (int)this.m_trainInstances.instance(i).value(this.m_classIndex);
            if (this.m_stored[cl] < this.m_Knn) {
                this.m_karray[cl][this.m_stored[cl]][0] = temp_diff;
                this.m_karray[cl][this.m_stored[cl]][1] = i;
                int n = cl;
                this.m_stored[n] = this.m_stored[n] + 1;
                ww = -1.0;
                for (j = 0; j < this.m_stored[cl]; ++j) {
                    if (!(this.m_karray[cl][j][0] > ww)) continue;
                    ww = this.m_karray[cl][j][0];
                    this.m_index[cl] = j;
                }
                this.m_worst[cl] = ww;
                continue;
            }
            if (!(temp_diff < this.m_karray[cl][this.m_index[cl]][0])) continue;
            this.m_karray[cl][this.m_index[cl]][0] = temp_diff;
            this.m_karray[cl][this.m_index[cl]][1] = i;
            ww = -1.0;
            for (j = 0; j < this.m_stored[cl]; ++j) {
                if (!(this.m_karray[cl][j][0] > ww)) continue;
                ww = this.m_karray[cl][j][0];
                this.m_index[cl] = j;
            }
            this.m_worst[cl] = ww;
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        ReliefFAttributeEval.runEvaluator(new ReliefFAttributeEval(), args);
    }
}

