/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.AbstractInstance;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class ReplaceMissingValues
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable {
    static final long serialVersionUID = 8349568310991609867L;
    private double[] m_ModesAndMeans = null;

    public String globalInfo() {
        return "Replaces all missing values for nominal and numeric attributes in a dataset with the modes and means from the training data.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_ModesAndMeans = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_ModesAndMeans == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_ModesAndMeans == null) {
            int i;
            double sumOfWeights = this.getInputFormat().sumOfWeights();
            double[][] counts = new double[this.getInputFormat().numAttributes()][];
            for (int i2 = 0; i2 < this.getInputFormat().numAttributes(); ++i2) {
                if (!this.getInputFormat().attribute(i2).isNominal()) continue;
                counts[i2] = new double[this.getInputFormat().attribute(i2).numValues()];
                if (counts[i2].length <= 0) continue;
                counts[i2][0] = sumOfWeights;
            }
            double[] sums = new double[this.getInputFormat().numAttributes()];
            for (int i3 = 0; i3 < sums.length; ++i3) {
                sums[i3] = sumOfWeights;
            }
            double[] results = new double[this.getInputFormat().numAttributes()];
            for (int j = 0; j < this.getInputFormat().numInstances(); ++j) {
                Instance inst = this.getInputFormat().instance(j);
                for (int i4 = 0; i4 < inst.numValues(); ++i4) {
                    if (!inst.isMissingSparse(i4)) {
                        double value = inst.valueSparse(i4);
                        if (inst.attributeSparse(i4).isNominal()) {
                            if (counts[inst.index(i4)].length <= 0) continue;
                            double[] dArray = counts[inst.index(i4)];
                            int n = (int)value;
                            dArray[n] = dArray[n] + inst.weight();
                            double[] dArray2 = counts[inst.index(i4)];
                            dArray2[0] = dArray2[0] - inst.weight();
                            continue;
                        }
                        if (!inst.attributeSparse(i4).isNumeric()) continue;
                        int n = inst.index(i4);
                        results[n] = results[n] + inst.weight() * inst.valueSparse(i4);
                        continue;
                    }
                    if (inst.attributeSparse(i4).isNominal()) {
                        if (counts[inst.index(i4)].length <= 0) continue;
                        double[] dArray = counts[inst.index(i4)];
                        dArray[0] = dArray[0] - inst.weight();
                        continue;
                    }
                    if (!inst.attributeSparse(i4).isNumeric()) continue;
                    int n = inst.index(i4);
                    sums[n] = sums[n] - inst.weight();
                }
            }
            this.m_ModesAndMeans = new double[this.getInputFormat().numAttributes()];
            for (i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (this.getInputFormat().attribute(i).isNominal()) {
                    if (counts[i].length == 0) {
                        this.m_ModesAndMeans[i] = Utils.missingValue();
                        continue;
                    }
                    this.m_ModesAndMeans[i] = Utils.maxIndex(counts[i]);
                    continue;
                }
                if (!this.getInputFormat().attribute(i).isNumeric() || !Utils.gr(sums[i], 0.0)) continue;
                this.m_ModesAndMeans[i] = results[i] / sums[i];
            }
            for (i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        AbstractInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] indices = new int[instance.numValues()];
            int num = 0;
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.isMissingSparse(j) && this.getInputFormat().classIndex() != instance.index(j) && (instance.attributeSparse(j).isNominal() || instance.attributeSparse(j).isNumeric())) {
                    if (this.m_ModesAndMeans[instance.index(j)] == 0.0) continue;
                    vals[num] = this.m_ModesAndMeans[instance.index(j)];
                    indices[num] = instance.index(j);
                    ++num;
                    continue;
                }
                vals[num] = instance.valueSparse(j);
                indices[num] = instance.index(j);
                ++num;
            }
            if (num == instance.numValues()) {
                inst = new SparseInstance(instance.weight(), vals, indices, instance.numAttributes());
            } else {
                double[] tempVals = new double[num];
                int[] tempInd = new int[num];
                System.arraycopy(vals, 0, tempVals, 0, num);
                System.arraycopy(indices, 0, tempInd, 0, num);
                inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
            }
        } else {
            double[] vals = new double[this.getInputFormat().numAttributes()];
            for (int j = 0; j < instance.numAttributes(); ++j) {
                vals[j] = instance.isMissing(j) && this.getInputFormat().classIndex() != j && (this.getInputFormat().attribute(j).isNominal() || this.getInputFormat().attribute(j).isNumeric()) ? this.m_ModesAndMeans[j] : instance.value(j);
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    public String toSource(String className, Instances data) throws Exception {
        int i;
        StringBuffer result = new StringBuffer();
        boolean[] numeric = new boolean[data.numAttributes()];
        boolean[] nominal = new boolean[data.numAttributes()];
        String[] modes = new String[data.numAttributes()];
        double[] means = new double[data.numAttributes()];
        for (i = 0; i < data.numAttributes(); ++i) {
            numeric[i] = data.attribute(i).isNumeric() && i != data.classIndex();
            nominal[i] = data.attribute(i).isNominal() && i != data.classIndex();
            means[i] = numeric[i] ? this.m_ModesAndMeans[i] : Double.NaN;
            modes[i] = nominal[i] ? data.attribute(i).value((int)this.m_ModesAndMeans[i]) : null;
        }
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /** lists which numeric attributes will be processed */\n");
        result.append("  protected final static boolean[] NUMERIC = new boolean[]{" + Utils.arrayToString(numeric) + "};\n");
        result.append("\n");
        result.append("  /** lists which nominal attributes will be processed */\n");
        result.append("  protected final static boolean[] NOMINAL = new boolean[]{" + Utils.arrayToString(nominal) + "};\n");
        result.append("\n");
        result.append("  /** the means */\n");
        result.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(means).replaceAll("NaN", "Double.NaN") + "};\n");
        result.append("\n");
        result.append("  /** the modes */\n");
        result.append("  protected final static String[] MODES = new String[]{");
        for (i = 0; i < modes.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            if (nominal[i]) {
                result.append("\"" + Utils.quote(modes[i]) + "\"");
                continue;
            }
            result.append(modes[i]);
        }
        result.append("};\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    Object[] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      if (i[n] == null) {\n");
        result.append("        if (NUMERIC[n])\n");
        result.append("          result[n] = MEANS[n];\n");
        result.append("        else if (NOMINAL[n])\n");
        result.append("          result[n] = MODES[n];\n");
        result.append("        else\n");
        result.append("          result[n] = i[n];\n");
        result.append("      }\n");
        result.append("      else {\n");
        result.append("        result[n] = i[n];\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    Object[][] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length][];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      result[n] = filter(i[n]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        ReplaceMissingValues.runFilter(new ReplaceMissingValues(), argv);
    }
}

